/**************************************************************************
These C++ classes are copyright 1989, 1990, 1991 by William Herrera.
I hereby release this source code for free distrubution and use.
If you modify it and distribute it, please indicate any changes you
make as your own and the code as copyrighted above.
**************************************************************************/

// file error.cpp error reporting class definitions.

#include <iostream.h>
#include <stdlib.h>

#include "error.hpp"


void (* Error::errfunc_i)(const int) = Error::iStateError;

void (* Error::errfunc_pcpci)
	(const char *, const char *, const char *, const int)
	= Error::pcpciStateError;


Error::Error(const int errlevel)
{
	(*errfunc_i)(errlevel);
}

Error::Error(const char * p, const char * q,
	const char * r, const int errlevel)
{
	(*errfunc_pcpci)(p, q, r, errlevel);
}

void Error::iStateError(const int errlevel)
{
	cerr << "\nError class reporting: runtime error"
		<< errlevel << '\n';
	if(errlevel != 0)
		exit(errlevel);
}

void Error::pcpciStateError(const char * p, const char * q,
	const char *r, const int errlevel)
{
	cerr << p << q << r;
	if(errlevel != 0)
		exit(errlevel);
}

void Error::SetiStateErrorFunc(void (*f)(const int))
{
	errfunc_i = f;
}

void Error::SetpcpciStateErrorFunc(void (*f)(const char *,
	const char *, const char *, const int))
{
	errfunc_pcpci = f;
}

// end of file error.cpp
