/* FS3.C
 * swap_system function
 * MSC8 (VC++ 1.5)
 * FS 2.9			
 * 270195
 * Copyright (C) M. van Breemen, 1992-1995, All rights reserved.
 *
 * fs_systemo is a tailored version of Ralf Browns' systemo which will pass the
 * current environment and calls the command interpreter without /C if 
 * command is ""
 *
 * fs_spawnvpeo is a replacement for spawnvpeo which is malfunctioning when
 * TBCHECK is active on some systems.
 */

#include <dos.h>
#include <io.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include "spawno.h"

int cdecl fs_systemo(const char *overlay_path, const char *command);
int _Cdecl fs_spawnvpeo(const char *overlay_path, const char *prog_name,
			const char **args, const char **env);
void locate_processor(char *command, char *processor);
unsigned int pascal __spawn_buildenv(const char **env) ;
void pascal __spawn_free_env(void) ;


int cdecl fs_systemo(const char *overlay_path, const char *command)
{
   char *comspec;
   char c_switch[3];
   char *arglist[4];           /* final argument list */

   comspec = getenv("COMSPEC") ;   
   if (!comspec || *comspec == '\0') comspec = "COMMAND";  /* default command interpreter */

   if (strlen(command)) strcpy(c_switch,"/C");             /* execute command and exit */
   else strcpy(c_switch," ");                              /* or just start the command interpreter */
							   /* this will save one instance of command */
   arglist[0]=comspec;
   arglist[1]=c_switch;
   arglist[2]=(char *) command;
   arglist[3]=(char *) 0L;

   return fs_spawnvpeo(overlay_path,comspec,arglist,_environ) ;
}



int _Cdecl fs_spawnvpeo(const char *overlay_path, const char *prog_name,
		     const char **args, const char **env)
{
   char prog_path[_MAX_PATH];

   /* find the processor location */
   locate_processor( (char *) prog_name, prog_path);

   /* ending with .BAT. We can't spawn a batch file */
   if (strstr(prog_path,".BAT")==(prog_path+strlen(prog_path)-4))
   {
      errno = ENOENT ;     /* path or filename not found */
      _doserrno= ENOENT;   /* not sure about this one */
      return -1 ;
   }

   /* Did we find a valid processor to spawn ? */
   if (strlen(prog_path))
   {
      int retval ;

      retval = __spawnv(overlay_path,prog_path,args,__spawn_buildenv(env)) ;
      __spawn_free_env() ;
      return retval ;
   }
   else
   {
      errno = ENOENT ;      /* path or filename not found */
      _doserrno= ENOENT;    /* not sure about this one */
      return -1 ;
   }
}
