/****************************************************************************

    Module  : DockWin.c

    Version : v1.0alpha

    Date    : 20/8/93

    Changes :  20/8/93 - Changed code which distinguishes between Windows
               .EXEs & DOS .EXEs to correctly choose.
               20/8/93 - Added use of RePaintSlot func to individually repaint
               slots.

               13/9/93 - Changed code which sets the window position when the
               user starts an application which has it's window position
               stored. Code now finds top parent window of currently active
               window instead of currently active window.

               30/3/94 - corrected code to handle the mail box shrinking &
               getting the correct size after. Tidied up the mail timer when
               the app finished. Corrected a bug which allowed the right
               button click to be processed whilst a slot was being dragged.

*****************************************************************************/

/****************************************************************************

    FUNCTION: DockWinProc(HWND hwnd, WORD message, WORD wParam, LONG lParam)

    VERSION : v1.0

    PURPOSE :

    MESSAGES:

    COMMENTS:

****************************************************************************/


#include <windows.h>            /* include standard windows header */
#include <shellapi.h>
#include <dir.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys\stat.h>
#include <string.h>
#include "freedock.h"           /* include control message definitions */


long FAR PASCAL DockWinProc(HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
    PAINTSTRUCT     ps;         /* paint struct , used when painting window */
    HDC             hdc;
    static HBITMAP  hBlank;
    static HANDLE   hInst;      /* stores instance handle of application */
    static HCURSOR  hRemCur;
    int             i, SlotHit, SlotIndex, FileIndex, nItem, Status;
    int             StartSlot, EndSlot;
    HDROP           hDrop;
    int             nNumDropped, nDropSlot;
    char            DroppedFileName[MAX_FPATH_LEN], TmpBuffer[MAX_FPATH_LEN];
    char           *TmpCharPtr;
    POINT           DropPoint;
    char            CommandLine[MAX_CMDLINE_LEN];
    static FARPROC  lpfnAppOptionsDlgProc, lpfnMainOptionsDlgProc, lpfnMailOptionsDlgProc, lpfnClockOptionsDlgProc,
                    lpfnWinExitOptionsDlgProc, lpfnExitDockDlgProc;
    static int      OrigSlot, OldX, OldY;
           int      NewX, NewY;
    static BOOL     bDragIcon, bRemoveSlot, bSlotOffDock, bSlotMove;
    static HBITMAP  hbmUnderIcon, hbmNewUnderIcon, hbmTmp;
    static HDC      hdcUnderIcon, hdcNewUnderIcon, hdcTmp;
    struct stat     StatBuf;
    SLOT_ENTRY      TmpSlot;

    /* Select messages which are handled by this procedure */

    switch (message) {

        case WM_CREATE:             /* The window has just been created */

            /* deretmine the instance handle of the application */
            hInst = ((LPCREATESTRUCT) lParam)->hInstance;

            /******************************************************
            Load the bitmaps for the blank button and the Title
            Icon, also load and Special Icons if required
            ******************************************************/

            hBlank = LoadBitmap(hInst, "SlotButton");

            /****************************************************
                Create a bitmap to store what is under the icon
                when moving a slot, + A scratch pad of the same
                size. (Tmp)
            ****************************************************/
            hdc = GetWindowDC(hwnd);
            hbmUnderIcon = CreateCompatibleBitmap( hdc,
                                                   SLOT_BUTTON_WIDTH,
                                                   SLOT_BUTTON_HEIGHT );
            hbmNewUnderIcon = CreateCompatibleBitmap( hdc,
                                                   SLOT_BUTTON_WIDTH,
                                                   SLOT_BUTTON_HEIGHT );
            hbmTmp = CreateCompatibleBitmap( hdc,
                                             SLOT_BUTTON_WIDTH,
                                             SLOT_BUTTON_HEIGHT );
            hdcUnderIcon = CreateCompatibleDC(hdc);
            hdcNewUnderIcon = CreateCompatibleDC(hdc);
            hdcTmp = CreateCompatibleDC(hdc);
            ReleaseDC(hwnd, hdc);
            SelectObject(hdcUnderIcon, hbmUnderIcon);
            SelectObject(hdcNewUnderIcon, hbmNewUnderIcon);
            SelectObject(hdcTmp, hbmTmp);

            /******************************************************
                Identify this window as a drag and drop acceptor
            ******************************************************/
            DragAcceptFiles(hwnd, TRUE);

            bDragIcon = FALSE;
            /**************************************************
            * Create all proc instances for all dialog boxes *
            **************************************************/
            lpfnAppOptionsDlgProc = MakeProcInstance((FARPROC) AppOptionsDlgProc, hInst);
            lpfnExitDockDlgProc = MakeProcInstance((FARPROC) ExitDockDlgProc, hInst);
            lpfnWinExitOptionsDlgProc = MakeProcInstance((FARPROC) WinExitOptionsDlgProc, hInst);
            lpfnMailOptionsDlgProc = MakeProcInstance((FARPROC) MailOptionsDlgProc, hInst);
            lpfnMainOptionsDlgProc = MakeProcInstance((FARPROC) MainOptionsDlgProc, hInst);
            lpfnClockOptionsDlgProc = MakeProcInstance((FARPROC) ClockOptionsDlgProc, hInst);

            if (DockOptions.AlwaysOnTop) {
                SetWindowPos(hwnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOACTIVATE);
            }
            if (DockOptions.MailActive) {
                SetTimer(hwnd, MAIL_TIMER, DockOptions.MailFreq * 1000 * 60, NULL);
            }
            return 0;               /* end of WM_CREATE */


        case WM_PAINT:
            hdc = BeginPaint(hwnd, &ps);
            StartSlot = FindSlotHit(DockOptions.Position, ps.rcPaint.left, ps.rcPaint.top);
            EndSlot = FindSlotHit(DockOptions.Position, ps.rcPaint.right, ps.rcPaint.bottom);

            for (i = StartSlot; i <= EndSlot; i++) {
                PaintSlot(hdc, hBlank, i);
            }
            EndPaint(hwnd, &ps);
            return 0;


        case WM_TIMER:
            if (wParam == MAIL_TIMER) {
                stat(DockOptions.MailPath, &StatBuf);
                if (StatBuf.st_size > DockOptions.MailBoxSize) {
                    DockOptions.MailBoxSize = (unsigned long) StatBuf.st_size;
                    i = 0;
                    while ((Slot[i].SlotType != SLOT_SPECIAL_MAIL) && (i < 4))
                        i++;
                    if (Slot[i].SlotType != SLOT_SPECIAL_MAIL){
                        KillTimer(hwndDock, MAIL_TIMER);
                        return 0;
                    }
                    Slot[i].IconHandle = LoadIcon(hAppInst, "MAILICON");
                    if (DockOptions.MailSound) {
                        MessageBeep(MB_ICONHAND);
                    }
                    RePaintSlot(i, FALSE);
                } else if (StatBuf.st_size < DockOptions.MailBoxSize) {
                    DockOptions.MailBoxSize = (unsigned long) StatBuf.st_size;
                }
            }
            return 0;

        case WM_LBUTTONDOWN:
             OldX = LOWORD(lParam);
             OldY = HIWORD(lParam);
             OrigSlot = FindSlotHit(DockOptions.Position, OldX, OldY);
             if(Slot[OrigSlot].SlotType == SLOT_USED){
                 /***********************************************************
                     Delete slot temporaraly & FORCE a repaint before
                     going any further.
                 ***********************************************************/
                 Slot[OrigSlot].SlotType = SLOT_FREE;
//                 RePaintSlot( OrigSlot, TRUE );
//                 SendMessage( hwnd, WM_PAINT, 0, 0L );

                 ShowCursor(FALSE);
//                 hdc = GetWindowDC(hwnd);
//                 /*****************************************
//                     Copy what will be under the Icon
//                 *****************************************/
//                 BitBlt( hdcUnderIcon, 0, 0, SLOT_BUTTON_WIDTH, SLOT_BUTTON_HEIGHT,
//                         hdc, OldX-19, OldY-19, SRCCOPY);
//                 /********************
//                     Draw the Icon
//                 ********************/
//                 DrawBitmap(hdc, hBlank, OldX-19, OldY-19);
//                 DrawIcon(hdc, (OldX-19)+3, (OldY-19)+3, Slot[OrigSlot].IconHandle);
//                 ReleaseDC(hwnd, hdc);

                 bDragIcon = TRUE;
                 bSlotMove = FALSE;
                 bRemoveSlot = FALSE;
             }
             else{
                 bDragIcon = FALSE;
                 bRemoveSlot = FALSE;
             }
             return 0;

        case WM_LBUTTONUP:
             if( bDragIcon ){
                 if(bSlotMove){
                     hdc = GetWindowDC(hwnd);
                     BitBlt( hdc, OldX-19, OldY-19, SLOT_BUTTON_WIDTH, SLOT_BUTTON_HEIGHT,
                             hdcUnderIcon, 0, 0, SRCCOPY);
                             ReleaseDC(hwnd, hdc);
                 }

                 SlotHit = FindSlotHit(DockOptions.Position, LOWORD(lParam), HIWORD(lParam));
                 if(bRemoveSlot){
                    memset(&Slot[OrigSlot], '\0', sizeof(SLOT_ENTRY) );
                    if(bSlotMove)
                        RePaintSlot(OrigSlot, TRUE);
                 }
                 else{
                     if( Slot[SlotHit].SlotType == SLOT_USED ){
                         Slot[OrigSlot].SlotType = SLOT_USED;
                         memcpy( &TmpSlot, &Slot[OrigSlot], sizeof(SLOT_ENTRY) );
                         memcpy( &Slot[OrigSlot], &Slot[SlotHit], sizeof(SLOT_ENTRY) );
                         memcpy( &Slot[SlotHit], &TmpSlot, sizeof(SLOT_ENTRY) );
                         if(bSlotMove)
                             RePaintSlot( OrigSlot, FALSE );
                     }
                     else if( Slot[SlotHit].SlotType == SLOT_FREE ){
                         memcpy( &Slot[SlotHit], &Slot[OrigSlot], sizeof(SLOT_ENTRY) );
                         Slot[SlotHit].SlotType = SLOT_USED;
                         if(bSlotMove)
                             RePaintSlot( OrigSlot, TRUE );
                     }
                     else {   // Slot must be a special, can't move a slot to here.
                         Slot[OrigSlot].SlotType = SLOT_USED;
                         if(bSlotMove)
                             RePaintSlot( OrigSlot, FALSE );
                     }
                 }
             if(bSlotMove){
                 RePaintSlot(SlotHit-1, TRUE);
                 RePaintSlot(SlotHit, TRUE);
                 RePaintSlot(SlotHit+1, TRUE);
             }
             ShowCursor(TRUE);
             bDragIcon = FALSE;
             ReleaseCapture();
             }
             return 0;

        case WM_MOUSEMOVE:
             if(bDragIcon){
                 if( IsCursorOutOfDock( LOWORD(lParam), HIWORD(lParam)) ){
                     if(!bRemoveSlot){
                         bSlotOffDock = FALSE;
                         bRemoveSlot = TRUE;
                         ShowCursor(TRUE);
                         hRemCur = LoadCursor(hAppInst, "RemoveSlot");
                         SetCursor( hRemCur );
                     }
                     if(bSlotOffDock) return(TRUE);
                 }
                 else if(bRemoveSlot){
                      bRemoveSlot = FALSE;
                      SetCursor(LoadCursor(NULL, IDC_ARROW));
                      ShowCursor(FALSE);
                      DestroyCursor(hRemCur);
                 }

                 if( !bSlotMove ){
                     hdc = GetWindowDC(hwnd);
                     /******************************************
                          Paint the area under the blank slot
                     ******************************************/
                     RePaintSlot( OrigSlot, TRUE );
                     SendMessage( hwnd, WM_PAINT, 0, 0L );
                     /*****************************************
                     Copy what will be under the Icon
                     *****************************************/
                     BitBlt( hdcUnderIcon, 0, 0, SLOT_BUTTON_WIDTH, SLOT_BUTTON_HEIGHT,
                             hdc, OldX-19, OldY-19, SRCCOPY);
                     /********************
                         Draw the Icon
                     ********************/
                     DrawBitmap(hdc, hBlank, OldX-19, OldY-19);
                     DrawIcon(hdc, (OldX-19)+3, (OldY-19)+3, Slot[OrigSlot].IconHandle);
                     ReleaseDC(hwnd, hdc);
                     bSlotMove = TRUE;
                     bDragIcon = TRUE;
                     SetCapture(hwnd);
                     return(TRUE);
                 }

                 /*****************************************************************
                     The following is an attempt at getting flicker free dragging
                     of a slot around the dock, third buffer required to eliminate
                     trailing/leading edge flicker when dragging
                 *****************************************************************/
                 NewX = LOWORD(lParam);
                 NewY = HIWORD(lParam);
                 hdc = GetWindowDC(hwnd);
                 // Blit what will be covered to Tmp
                 BitBlt( hdcNewUnderIcon, 0, 0, SLOT_BUTTON_WIDTH, SLOT_BUTTON_HEIGHT,
                         hdc, NewX-19, NewY-19, SRCCOPY);

                 // Blit UnderIcon to old-new in tmp
                 BitBlt( hdcNewUnderIcon, (OldX)-NewX, (OldY)-NewY, SLOT_BUTTON_WIDTH, SLOT_BUTTON_HEIGHT,
                         hdcUnderIcon, 0, 0, SRCCOPY);

                 // Draw complete Icon into buffer & then blit to screen
                 DrawBitmap(hdcTmp, hBlank, 0, 0);
                 DrawIcon(hdcTmp, 3, 3, Slot[OrigSlot].IconHandle);
                 // Draw Icon into Under Icon Bmp at new-old
                 DrawBitmap(hdcUnderIcon, hBlank, NewX-(OldX), NewY-(OldY));
                 DrawIcon(hdcUnderIcon, (NewX-(OldX))+3, (NewY-(OldY))+3, Slot[OrigSlot].IconHandle);

                 // Blit complete icon to screen
                 BitBlt( hdc, NewX-19, NewY-19, SLOT_BUTTON_WIDTH, SLOT_BUTTON_HEIGHT,
                         hdcTmp, 0, 0, SRCCOPY);

                 // Replace what was covered by the icon, and is not covered by new pos
                 BitBlt( hdc, (OldX-19), (OldY-19), SLOT_BUTTON_WIDTH, SLOT_BUTTON_HEIGHT,
                         hdcUnderIcon, 0, 0, SRCCOPY);

                 // Save new image of what's under the icon.
                 BitBlt( hdcUnderIcon, 0, 0, SLOT_BUTTON_WIDTH, SLOT_BUTTON_HEIGHT,
                         hdcNewUnderIcon, 0, 0, SRCCOPY);

                 // Save new posn
                 OldX = NewX;
                 OldY = NewY;

                 if(!bSlotOffDock) bSlotOffDock = TRUE;
                 ReleaseDC(hwnd, hdc);
             }
             return 0;


        case WM_LBUTTONDBLCLK:
        /*******************************************************************
           First need to calculate which button has been hit, by dividing
           the y coordinate by the height of the buttons and subtracting
           the number of special buttons operational and 1 for the title
           Icon.
        *******************************************************************/

        SlotHit = FindSlotHit(DockOptions.Position, LOWORD(lParam), HIWORD(lParam));

        switch (Slot[SlotHit].SlotType) {
            case SLOT_USED:
                ExecSlot( SlotHit, Slot[SlotHit].CmdLine );
                break;

            case SLOT_SPECIAL_MAIL:
                Slot[SlotHit].IconHandle = LoadIcon(hAppInst, "NOMAILICON");
                RePaintSlot(SlotHit, FALSE);
                break;

            case SLOT_SPECIAL_EXIT:
                if (DockOptions.WinExitConfirm) {
                    nItem = MessageBox(hwnd, "Do you really want to exit Windows ?",
                                        "Free Dock", MB_OKCANCEL | MB_ICONSTOP);
                    if (nItem == IDOK) {
                        ExitWindows(0, 0);
                        WriteINIFile(Slot, DockOptions.DockSize);
						  }
					 } else {
						  WriteINIFile(Slot, DockOptions.DockSize);
						  ExitWindows(0, 0);
					 }
					 break;

				case SLOT_SPECIAL_TITLE:
					DialogBox(hInst, "EXITDOCKDLG", hwnd, lpfnExitDockDlgProc);
					break;

		 }
		 return 0;

	 case WM_DROPFILES:

		  hDrop = wParam;

		  /*******************************************
				Find out how many files were dropped
        *******************************************/
        nNumDropped = DragQueryFile(hDrop, -1, DroppedFileName, MAX_FPATH_LEN);

        DragQueryPoint(hDrop, &DropPoint);

        SlotHit = FindSlotHit(DockOptions.Position, DropPoint.x, DropPoint.y);

        switch (Slot[SlotHit].SlotType) {

        case SLOT_USED:
            /***********************************************************
                Build up the command line and then call the ExecSlot
                function to execute the associated program
            ***********************************************************/
            sprintf(CommandLine, "%s ", Slot[SlotHit].CmdLine);
            for (FileIndex = 0; FileIndex < nNumDropped; FileIndex++) {
                DragQueryFile(hDrop, FileIndex, DroppedFileName, MAX_FPATH_LEN);
                /************************************************
                    Check if this file has an extension, if not
                    add a trailing '.'
                ************************************************/
					 if (!strchr(&DroppedFileName[strlen(DroppedFileName) - 4], '.')) {
                    DroppedFileName[strlen(DroppedFileName) + 1] = '\0';
                    DroppedFileName[strlen(DroppedFileName)] = '.';
                }
                strcat(CommandLine, DroppedFileName);
            }

				ExecSlot( SlotHit, CommandLine );

            break;

        case SLOT_FREE:
            nDropSlot = SlotHit;
            SlotIndex = SlotHit;
            for (FileIndex = 0; FileIndex < nNumDropped; FileIndex++) {
                DragQueryFile(hDrop, FileIndex, DroppedFileName, MAX_FPATH_LEN);
                Slot[SlotIndex].SlotType = SLOT_USED;
                Slot[SlotIndex].StartState = START_NORMAL;
                Slot[SlotIndex].WinX = DEF_STORE_X;
                Slot[SlotIndex].WinY = DEF_STORE_Y;
                Slot[SlotIndex].WinWidth = DEF_STORE_W;
                Slot[SlotIndex].WinHeight = DEF_STORE_H;
                strcpy(Slot[SlotIndex].AppName, DroppedFileName);
                strcpy(Slot[SlotIndex].RunTimeDir, DroppedFileName);
                strcpy(Slot[SlotIndex].IconFile, DroppedFileName);
                Slot[SlotIndex].IconPos = 0;

                /************************************************
                   Set Run Time Dir to be same path as filename
					 ************************************************/
                TmpCharPtr = strrchr(Slot[SlotIndex].RunTimeDir, '\\');
                if (*(TmpCharPtr-1) == ':')
                    *(TmpCharPtr+1) = '\0';
                else
                    *TmpCharPtr = '\0';

					 /*****************************************************************
                    Check What type of file has been dropped, is it a .PIF, .COM
                    or a .BAT ?
                *****************************************************************/
                if (!stricmp(&DroppedFileName[strlen(DroppedFileName) - 4], ".PIF") ||
                    !stricmp(&DroppedFileName[strlen(DroppedFileName) - 4], ".COM") ||
                    !stricmp(&DroppedFileName[strlen(DroppedFileName) - 4], ".BAT")) {
                    GetWindowsDirectory(Slot[SlotIndex].IconFile, MAX_FPATH_LEN);
                    /**********************************************************
                       only add \ to path if it is not already there i.e. P:\
                    **********************************************************/
                    if (Slot[SlotIndex].IconFile[strlen(Slot[SlotIndex].IconFile) - 1] == '\\') {
                        strcat(Slot[SlotIndex].IconFile, "PROGMAN.EXE");
                    } else {
                        strcat(Slot[SlotIndex].IconFile, "\\PROGMAN.EXE");
                    }
                    Slot[SlotIndex].IconPos = 1;
                    Slot[SlotIndex].IconHandle = ExtractIcon(hInst, Slot[SlotIndex].IconFile, Slot[SlotIndex].IconPos);
                }
                /******************************************************************
                    Is is a .EXE, if so is it a Windows EXE or a DOS EXE ?
                ******************************************************************/
					 else if (!stricmp(&DroppedFileName[strlen(DroppedFileName) - 4], ".EXE")) {
                    Slot[SlotIndex].IconHandle = ExtractIcon(hInst, Slot[SlotIndex].IconFile, Slot[SlotIndex].IconPos);
                    if (Slot[SlotIndex].IconHandle == 1) {
                        GetWindowsDirectory(Slot[SlotIndex].IconFile, MAX_FPATH_LEN);
                        if (Slot[SlotIndex].IconFile[strlen(Slot[SlotIndex].IconFile) - 1] == '\\') {
                            strcat(Slot[SlotIndex].IconFile, "PROGMAN.EXE");
                        } else {
									 strcat(Slot[SlotIndex].IconFile, "\\PROGMAN.EXE");
                        }
                        Slot[SlotIndex].IconPos = 1;
                        Slot[SlotIndex].IconHandle = ExtractIcon(hInst, Slot[SlotIndex].IconFile, Slot[SlotIndex].IconPos);
                    }
                }
                /******************************************************************
                    It must be a document file, try to find an association for it
                ******************************************************************/
                else {
                    strcpy(Slot[SlotIndex].CmdLine, Slot[SlotIndex].AppName);
                    // Read the executable name in,
                    // then call searchpath to get entrire path for application.
                    Status = FindExecutable(Slot[SlotIndex].CmdLine,
                                            Slot[SlotIndex].RunTimeDir,
                                            Slot[SlotIndex].AppName);
                    TmpCharPtr = searchpath( Slot[SlotIndex].AppName );
                    if(TmpCharPtr) strcpy( Slot[SlotIndex].AppName, TmpCharPtr);

                    if (Status > 32) {
                        strcpy(Slot[SlotIndex].IconFile, Slot[SlotIndex].AppName);
                        Slot[SlotIndex].IconPos = 0;
								Slot[SlotIndex].IconHandle = ExtractIcon(hInst, Slot[SlotIndex].IconFile, Slot[SlotIndex].IconPos);
                    } else {
                        sprintf(TmpBuffer, "%s\nis not an executable or an associated file", Slot[SlotIndex].CmdLine);
                        MessageBox(hwnd, TmpBuffer, "FreeDock", MB_OK | MB_ICONSTOP);
                        Slot[SlotIndex].SlotType = SLOT_FREE;
                    }
                }

                RePaintSlot(SlotIndex, FALSE);

                SlotIndex++;
                while ((SlotIndex != nDropSlot) && (Slot[SlotIndex].SlotType != SLOT_FREE)) {
                    SlotIndex++;
                    if (SlotIndex >= DockOptions.DockSize)
                        SlotIndex = 1;
                }
                if (SlotIndex == nDropSlot)
                    break;
            }
            WriteINIFile(Slot, DockOptions.DockSize);
            break;

        }

        DragFinish(hDrop);

        return 0;

    case WM_RBUTTONDOWN:
		  /*************************************************
            If we are currently dragging a slot around
            then ignore any buttons being pressed
        *************************************************/
        if( bDragIcon ) return 0;

        SlotHit = FindSlotHit(DockOptions.Position, LOWORD(lParam), HIWORD(lParam));

		  switch (Slot[SlotHit].SlotType) {
        case SLOT_USED:
            CurSlot = SlotHit;  /* set global index to target slot */
            Status = DialogBox(hInst, "APPOPTIONSDLG", hwnd, lpfnAppOptionsDlgProc);
            if(Status) WriteINIFile(Slot, DockOptions.DockSize);
            break;

        case SLOT_SPECIAL_TITLE:
            Status = DialogBox(hInst, "MAINOPTIONSDLG", hwnd, lpfnMainOptionsDlgProc);
            break;

        case SLOT_SPECIAL_EXIT:
            Status = DialogBox(hInst, "WINEXITOPTIONSDLG", hwnd, lpfnWinExitOptionsDlgProc);
            break;

        case SLOT_SPECIAL_MAIL:
            Status = DialogBox(hInst, "MAILOPTIONSDLG", hwnd, lpfnMailOptionsDlgProc);
            break;

        case SLOT_SPECIAL_CLOCK:
            Status = DialogBox(hInst, "CLOCKOPTIONSDLG", hwnd, lpfnClockOptionsDlgProc);
				break;
        }

        return 0;


    case WM_CLOSE:
        WriteINIFile(Slot, DockOptions.DockSize);
        DestroyWindow(hwnd);
        return 0;

    case WM_QUIT:
    case WM_DESTROY:
        WriteINIFile(Slot, DockOptions.DockSize);
        FreeProcInstance(lpfnAppOptionsDlgProc);
        FreeProcInstance(lpfnExitDockDlgProc);
        FreeProcInstance(lpfnWinExitOptionsDlgProc);
        FreeProcInstance(lpfnMailOptionsDlgProc);
        FreeProcInstance(lpfnMainOptionsDlgProc);
        FreeProcInstance(lpfnClockOptionsDlgProc);
        KillTimer(hwndDock, MAIL_TIMER);
        PostQuitMessage(0);
        return 0;

    }

    /* return all unused mesages to the system */
    return DefWindowProc(hwnd, message, wParam, lParam);
}
