#ifndef __OPTIONS_H__
#define __OPTIONS_H__

//--------------  Options Dialog Box Defines ----------------------

// The size options MUST be less than 256 (use the low byte only)
#define IDB_SIZEFIRST   200
#define IDB_LARGER      200
#define IDB_SMALLER     201
#define IDB_SIZE1       202
#define IDB_SIZE2       203
#define IDB_CUSTOM      204
#define IDB_SIZELAST    IDB_CUSTOM

// These options must be separate individual bits in the high byte
#define IDB_FILL        0x0100
#define IDB_STRETCH     0x0200
#define IDB_TILE        0x0400
#define IDB_16COLORS    0x1000
#define IDB_15COLORS    0x2000

#define OPTIONSCHANGED  0x8000

// These just need to be different than the previous values.
// Numbers greater than 256 that aren't powers of 2 work fine.
#define IDE_WIDTH       301
#define IDE_HEIGHT      302
#define IDC_WIDTH       303
#define IDC_HEIGHT      304

//--------------  Step-Size Dialog Box Defines --------------------

#define IDE_STEPS       401

//--------------  OPTIONS structure type definition ---------------

typedef struct
  {
  WORD wFlags;
  UINT nWidth;  // nWidth & nHeight are only used if size is IDB_CUSTOM
  UINT nHeight;
  int  nSteps;
  } OPTIONS, FAR * LPOPTIONS;

//--------------  Function prototypes -----------------------------

void ReadOptions(OPTIONS *pOptions);
void WriteOptions(OPTIONS *pOptions);
BOOL FAR PASCAL OptionsDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL StepDlgProc(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);
BOOL SizeDIB(HGLOBAL *phdib, PALETTEENTRY *pe, LONG dwWidth, LONG dwHeight, WORD wMode);

#endif // __OPTIONS_H__
