/*******************************************************************************
** OUTBUFF - OutputBuffer class
** Created 5/25/95 by John Stockton
** CIS: 76041,2534
** INTERNET: jstockton%inova@mcimail.com
**
** Copyright (c) 1995 INOVA Corporation.  May be copied, used and distributed, 
** as long as no charge is made for its use and this copyright notice is not
** altered or removed.
**
** $Header: j:/library/express/rcs/outbuff.cpp 1.4 1995/06/29 15:08:36 JOHN Exp $
*******************************************************************************/

#include "outbuff.hpp"
#include <assert.h>

const unsigned short OUTPUT_BUFFER_VECTOR_SIZE = 64;

OutputBuffer::OutputBuffer( void) :
      aBuffer( OUTPUT_BUFFER_VECTOR_SIZE, 0, OUTPUT_BUFFER_VECTOR_SIZE),
      pBuffer( 0)
{
}


OutputBuffer::~OutputBuffer( void)
{
   delete this->pBuffer;
}


OutputBuffer &OutputBuffer::operator<<( BYTE b)
{
   if (!IsFrozen())
      this->aBuffer.Add( b);
   else
      assert( !IsFrozen());

   return *this;
}


OutputBuffer &OutputBuffer::operator<<( const char *s)
{
   if (!IsFrozen())
   {
      BYTE *b = (BYTE *) s;
      do {
         this->aBuffer.Add( *b);
      } while (*(b++));
   }
   else
      assert( !IsFrozen());

   return *this;
}


OutputBuffer &OutputBuffer::operator<<( const OutputBuffer &cb)
{
   if (!IsFrozen())
   {
      for (TArrayAsVectorIterator<BYTE> i(cb.aBuffer);
            i; i++)
         this->aBuffer.Add( i.Current());
   }
   else
      assert( !IsFrozen());

   return *this;
}


OutputBuffer::operator const BYTE *( void)
{
   if (!IsFrozen())
   {
      BYTE *pCurrent = this->pBuffer = new BYTE[ GetSize()];
      for (TArrayAsVectorIterator<BYTE> i(this->aBuffer);
            i; pCurrent++, i++)
         *pCurrent = i.Current();
   }
   else
      assert( !IsFrozen());

   return this->pBuffer;
}


unsigned OutputBuffer::GetSize( void) const
{
   return this->aBuffer.GetItemsInContainer();
}


BOOL OutputBuffer::IsFrozen( void)
{
   return BOOL( this->pBuffer);
}


void OutputBuffer::Reset( void)
{
   delete this->pBuffer;
   this->pBuffer = 0;

   this->aBuffer.Flush();
}
