%{
/******************************************************************************/
/*  expr.y  -	An expression Evaluator.				      */
/*  Author  - Sandeep Dutta (71172.2525@compuserve.com) (SandeepD@aol)	      */
/*	      This program is a good demostration of the marraige between     */
/*	      YACC and C++ using the Borland C++ Classlibrary.		      */
/******************************************************************************/

#include <iostream.h>
#include <stdio.h>
#include <ctype.h>
#include <assoc.h>
#include <dict.h>
#include <strng.h>
#include <object.h>
#include <math.h>

#define MAXLINESZ  4072
#define MAXTOKENSZ 50

void yyerror(char *) ;
extern int yyparse ()	    ;
extern int yylex()	    ;
int nc = 0 ;
int yyerrorflg	= 0	    ;
istream& yyin	= cin	    ;

Dictionary  SymbolTable     ;

enum SymType  { Ident , Lit, Oper } ;

// base class for Symbol
class Symbol : public Object {

    protected:
    SymType	type;
    int 	hvalue;

    public:
    hashValueType   hashValue() const	{   return (hashValueType) 0 ;	} ;
    classType	    isA()	const	{   return __firstUserClass  ;	} ;
    char    _FAR   *nameOf()	const	{   return "Symbol" ;	 } ;
    SymType	    Stype()	const	{   return type;	 } ;
    virtual float   Svalue()	const = 0 ;
    virtual int     isOper()	const = 0 ;

    ~Symbol()				{} ;

};

// Identifier class sub-class for Symbol
class Identifier  :  public  Symbol {

    String  *name	;	    // name of Identifier
    float   value	;	    // value stored in this var

    public:
    int     isEqual( const Object _FAR & o )	const	{
				    return *(((Identifier&)o).name) == *name ; };
    void    printOn( ostream _FAR & os) 	const	{
				    os << value ;
				    };
    float   Svalue ()		    const   {	return value ;		};
    int     isOper ()		    const   {	return 0 ;		};

    Identifier ( char *sname )	{

	    name    = new String(sname) ;
	    Symbol::type = Ident ;
	    value   = (float) 0  ;
    };

    ~Identifier ()		{
	    delete name ;
    };

    Identifier& Assign( Symbol& sSym )	{
				    value   = sSym.Svalue() ;
				    return  *this ;
				    };
    Identifier& Assign(float	val  )	{
				    value   = val ;
				    return  *this ;
				    };
    void	PrintName(ostream& ost) const	{
				    ost << *name ;
				    };

};

// Literal class sub-class for Symbol
class Literal :  public Symbol {

    float	value	;
    public:
    int 	isEqual(const Object _FAR & o)	const	{
				    return ((Literal &) o).value == value ;
				    };

    void	printOn(ostream _FAR & ost)	const {  ost << value ; } ;
    float	Svalue()	    const   {  return value ; } ;
    int 	isOper()	    const   {  return 0 ;     } ;

    Literal	(float	f)	    {
				    value = f ;
				    Symbol::type = Lit ;
				    };

};

// Operator class sub-class for Symbol
class Operator	: public  Symbol  {

    int     Optype  ;	    // operator

    public:
    int     isEqual(const Object _FAR & o)  const   {
				    return ((Operator &)o).Optype == Optype ;
				};
    void    printOn(ostream _FAR & ost)     const {
				    ost << Optype ;
				};
    float   Svalue()		const	{
				    cerr << "Invalid call to Svalue()\n";
				    return (float) 0 ;
				};
    int     isOper()		const	{   return Optype ;  } ;

    Operator( int Op )		{
				    Optype = Op ;
				    Symbol::type = Oper ;
				};

};

// expression tree
struct	 ExprTree    {
    Symbol	*TNode	;	// this node
    ExprTree	*Ltree	;	// Left Tree
    ExprTree	*Rtree	;	// right Tree
};

extern float	EvalTree(ExprTree *) ;
extern float	CallFunc(Symbol *, float) ;

%}
%left		 EQUAL
%right		 BO
%left		 BC
%left		 FUNCTION
%left		 BAND , BOR    , BXOR
%left		 LSH  , RSH
%left		 MOD  , POWER
%left		 STAR , SLASH
%left		 PLUS , MINUS
%token	<yysym>  IDENTIFIER
%left		 NEWLINE

%union {
    char	yyint	 ;
    Symbol     *yysym	 ;
    ExprTree   *yyEtree  ;
}

%type	<yyEtree>     assign_statement, expr,	addition,   factor, division
%type	<yyEtree>     bitand,	bitor , modulus,power,	lshift
%type	<yyEtree>     rshift,	term

%start list
%%

list :	 statement	    { printf ("[%d] ",nc) ;	     }
     |	 list statement     { printf ("[%d] ",nc) ;	     }
     ;

statement   :  assign_statement  NEWLINE    { nc++ ; cout << EvalTree($1) << "\n"; }
	    |  NEWLINE
	    ;

assign_statement : IDENTIFIER EQUAL expr {
					   if ($1->Stype() != Ident) {
						yyerror("Lvalue required for assign\n");
					   } else {
						ExprTree *Etree = new ExprTree;
						Etree->Ltree	= new ExprTree;
						Etree->Ltree->TNode = $1;
						Etree->TNode	= Equal ;
						Etree->Rtree	= $3	;
						$$   = Etree ;
					   }
					}
		 | expr 		{  $$	=   $1; }
                 ;

expr	 :  addition MINUS expr 	{
					    ExprTree *Etree = new ExprTree ;
					    Etree->TNode    = Minus ;
					    Etree->Ltree    = $1  ;
					    Etree->Rtree    = $3  ;
					    $$	= Etree 	 ;
					}
	 |  addition			{   $$	=   $1; }
         ;

addition :  factor   PLUS  addition	{
					    ExprTree *Etree = new ExprTree ;
					    Etree->TNode    = Plus ;
					    Etree->Ltree    = $1  ;
					    Etree->Rtree    = $3  ;
					    $$	= Etree 	 ;
					}
	 |  factor			{   $$	=   $1; }
         ;

factor	 :  division STAR  factor	{
					    ExprTree *Etree = new ExprTree ;
					    Etree->TNode    = Star ;
					    Etree->Ltree    = $1  ;
					    Etree->Rtree    = $3  ;
					    $$	= Etree 	 ;
					}
	 |  division			{   $$	=   $1; }
         ;

division :  bitand   SLASH division	{
					    ExprTree *Etree = new ExprTree ;
					    Etree->TNode    = Slash ;
					    Etree->Ltree    = $1  ;
					    Etree->Rtree    = $3  ;
					    $$	= Etree 	 ;
					}
	 |  bitand			{   $$	=   $1; }
         ;

bitand	 :  bitor    BAND  bitand	{
					    ExprTree *Etree = new ExprTree ;
					    Etree->TNode    = Band ;
					    Etree->Ltree    = $1  ;
					    Etree->Rtree    = $3  ;
					    $$	= Etree 	 ;
					}
	 |  bitor			{   $$	=   $1; }
         ;

bitor	 :  modulus BOR bitor		{
					    ExprTree *Etree = new ExprTree ;
					    Etree->TNode    = Bor ;
					    Etree->Ltree    = $1  ;
					    Etree->Rtree    = $3  ;
					    $$	= Etree 	 ;
					}
	 |  modulus			{   $$	=   $1; }
	 ;

modulus  :  power   MOD  modulus	{
					    ExprTree *Etree = new ExprTree ;
					    Etree->TNode    = Mod ;
					    Etree->Ltree    = $1  ;
					    Etree->Rtree    = $3  ;
					    $$	= Etree 	 ;
					}
	 |  power			{   $$	=   $1; }
	 ;

power	 :  lshift  POWER  power	{
					    ExprTree *Etree = new ExprTree ;
					    Etree->TNode    = Power ;
					    Etree->Ltree    = $1  ;
					    Etree->Rtree    = $3  ;
					    $$	= Etree 	 ;
					}
	 |  lshift			{   $$	=   $1; }
	 ;

lshift	 :  rshift  LSH  lshift 	{
					    ExprTree *Etree = new ExprTree ;
					    Etree->TNode    = Lsh ;
					    Etree->Ltree    = $1  ;
					    Etree->Rtree    = $3  ;
					    $$	= Etree 	 ;
					}
	 |  rshift			{   $$	=   $1; }
	 ;

rshift	 :  term    RSH  rshift 	{
					    ExprTree *Etree = new ExprTree ;
					    Etree->TNode    = Rsh ;
					    Etree->Ltree    = $1  ;
					    Etree->Rtree    = $3  ;
					    $$	= Etree 	 ;
					}
	 |  term			{   $$	=   $1; }
	 ;

term	 :  IDENTIFIER			{
					    ExprTree *Etree = new ExprTree ;
					    Etree->TNode    = $1 ;
					    $$		    = Etree ;
					}
	 |  IDENTIFIER BO expr BC	{
					    if ($1->Stype() != Ident) {
						yyerror("Expected Identifier\n");
					    } else {

						ExprTree *Etree = new ExprTree ;
						Etree->Ltree	= new ExprTree ;
						Etree->TNode	= Function     ;
						Etree->Ltree->TNode = $<yysym>1;
						Etree->Rtree	= $3	       ;
						$$		= Etree        ;
					    }
					}
	 |  BO expr BC			{   $$ = $2 ;	}
	 ;

%%


// Expression Tree evaluator
float	EvalTree   ( ExprTree *Etree ) {

    Symbol *CurrSym ;
    float   lvalue  , rvalue ;

    if (yyerrorflg) {
	cerr << "Error detected in expression; Evaluation terminated\n" ;
	return (float) 0;
    }

    // if not operator then return value
    if (!Etree->TNode->isOper()) {
	CurrSym = Etree->TNode	 ;
	delete	Etree		 ;  // delete this node
	return CurrSym->Svalue() ;
    }

    // if operator then do as required
    switch (Etree->TNode->isOper()) {
    case PLUS :
	lvalue = EvalTree(Etree->Ltree) ;
	rvalue = EvalTree(Etree->Rtree) ;
	delete	Etree ;
	return	 ( lvalue + rvalue ) ;
    case MINUS :
	lvalue = EvalTree(Etree->Ltree) ;
	rvalue = EvalTree(Etree->Rtree) ;
	delete	Etree ;
	return	 ( lvalue - rvalue ) ;
    case STAR :
	lvalue = EvalTree(Etree->Ltree) ;
	rvalue = EvalTree(Etree->Rtree) ;
	delete	Etree ;
	return	 ( lvalue * rvalue ) ;
    case SLASH :
	lvalue = EvalTree(Etree->Ltree) ;
	rvalue = EvalTree(Etree->Rtree) ;
	delete	Etree ;
	return	 ( lvalue / rvalue ) ;
    case MOD :
	lvalue = EvalTree(Etree->Ltree) ;
	rvalue = EvalTree(Etree->Rtree) ;
	delete	Etree ;
	return	 ((float) ((int) lvalue % (int)rvalue) ) ;
    case LSH :
	lvalue = EvalTree(Etree->Ltree) ;
	rvalue = EvalTree(Etree->Rtree) ;
	delete	Etree ;
	return	 ((float)((int) lvalue << (int) rvalue) ) ;
    case RSH :
	lvalue = EvalTree(Etree->Ltree) ;
	rvalue = EvalTree(Etree->Rtree) ;
	delete	Etree ;
	return	 ((float)((int) lvalue >> (int) rvalue) ) ;
    case BOR :
	lvalue = EvalTree(Etree->Ltree) ;
	rvalue = EvalTree(Etree->Rtree) ;
	delete	Etree ;
	return	 ((float)((int) lvalue | (int) rvalue) ) ;
    case BAND:
	lvalue = EvalTree(Etree->Ltree) ;
	rvalue = EvalTree(Etree->Rtree) ;
	delete	Etree ;
	return	 ((float)((int) lvalue & (int) rvalue) ) ;
    case POWER:
	lvalue = EvalTree(Etree->Ltree) ;
	rvalue = EvalTree(Etree->Rtree) ;
	delete	Etree ;
	return	 ((float) pow((double) lvalue,(double) rvalue));
    case EQUAL:
	rvalue = EvalTree(Etree->Rtree) ;
	CurrSym = Etree->Ltree->TNode ;
	((Identifier *)CurrSym)->Assign(rvalue) ;
	delete Etree ;
	return(CurrSym->Svalue()) ;
    case FUNCTION:
	rvalue = EvalTree(Etree->Rtree) ;
	CurrSym = Etree->Ltree->TNode	;
	delete Etree ;
	return(CallFunc(CurrSym,rvalue)) ;
    default:
	cerr << "Unrecognized Operator\n" ;
	return (float) 0 ;
    }
}

Symbol	*SymLookUp( char *sid ) {

	String	*sname	=   new String(sid) ;
	Association& tassoc = SymbolTable.lookup(*sname) ;
	if (tassoc == NOOBJECT) {
	    Identifier	*tIdent = new Identifier(sid) ;
	    Association *ttassoc= new Association(*sname, *tIdent) ;
	    SymbolTable.add(*ttassoc) ;
	    return (tIdent) ;
	}

	return ((Symbol*) &tassoc.value()) ;
}


// the lexical analyser
int yylex()	{

    static  char  buffer[MAXLINESZ]  ;
    static  char *pbuff = (char *) 0 ;
    char	  yytext[MAXTOKENSZ];
    char	 *pyytext = yytext   ;
    int     tint   ;
    float   tfloat ;
    int     tdotf  = 0 ;

    _yytop :

    // if buffer is empty fill it up
    if (pbuff == (char *) 0 || *pbuff == '\0') {
	char *tpbuff ;
	pbuff = buffer ;

	__readline:
	while ((*pbuff = yyin.get()) != '\n' && (!yyin.eof()))
		 pbuff++ ;
	// eof has been reached
	if ( yyin.eof() && (pbuff == buffer))
	    return -1 ;
	// put newline & delimiter
	*pbuff	 = '\n'; pbuff++ ;
	*pbuff	 = '\0';

	// check if line continuation exists

	tpbuff = strchr(buffer,'\n') ;
	while (isspace(*tpbuff)) tpbuff-- ;
	// if '\\' then continuation exists
	if (*tpbuff == '\\') {
	    pbuff = tpbuff ;
	    goto __readline ;
	}
	pbuff = buffer ;
    } // buffer fill done.

    // skip thru white space
    while ((*pbuff == '\t') || (*pbuff == ' ')) pbuff++ ;

    // check if any operator
    switch (*pbuff) {
    case '+' :
	pbuff++ ;
	return(PLUS) ;
    case '-' :
	pbuff++ ;
	return(MINUS) ;
    case '*' :
	pbuff++ ;
	return(STAR)  ;
    case '/' :
	pbuff++ ;
	return(SLASH) ;
    case '&' :
	pbuff++ ;
	return(BAND) ;
    case '|' :
	pbuff++ ;
	return(BOR) ;
    case '^' :
	pbuff++     ;
	return(POWER);
    case '~' :
	pbuff++     ;
	return(BXOR);
    case '=' :
	pbuff++     ;
	return(EQUAL) ;
    case '%' :
	pbuff++     ;
	return(MOD) ;
    case '(' :
	pbuff++     ;
	return(BO)  ;
    case ')' :
	pbuff++     ;
	return(BC)  ;
    case '>' :
	pbuff++     ;
	if (*pbuff == '>') {
	    pbuff++ ;
	    return(RSH) ;
	} else cerr << "Error '>'\n" ;
	break ;
    case '<' :
	pbuff++     ;
	if (*pbuff == '<') {
	    pbuff++ ;
	    return (LSH) ;
	} else cerr << "Error '<'\n" ;
	break ;
    case '\n' :
	pbuff++ ;
	return(NEWLINE) ;
    }

    // check if hexadecimal literal
    if ( (*pbuff == '0') && (*(pbuff+1) == 'x') ) {

	// copy over 0x
	*pyytext++ = *pbuff++ ;
	*pyytext++ = *pbuff++ ;
	while (isxdigit(*pbuff)) *pyytext++ = *pbuff++ ;
	*pyytext = '\0' ;

	sscanf(yytext,"%x",&tint) ;
	Literal *tLit = new Literal((float) tint);
	yylval.yysym = tLit ;
	return(IDENTIFIER) ;
    }

    // check if numeric literal
    if (isdigit(*pbuff) || (*pbuff == '.')) {

	while (isdigit(*pbuff) || (*pbuff == '.')) {
	    if (*pbuff == '.' ) {
		if (tdotf)  break ;
		else	    tdotf = 1 ;
	    }
	    *pyytext++ = *pbuff++ ;
	}
	*pyytext = '\0' ;
	sscanf(yytext,"%f",&tfloat) ;
	Literal *tLit = new Literal(tfloat) ;
	yylval.yysym = tLit ;
	return (IDENTIFIER) ;
    }

    // check for identifier
    if (isalpha(*pbuff)) {
	while (isalpha(*pbuff) || isdigit(*pbuff))
	    *pyytext++ = *pbuff++ ;
	*pyytext = '\0' ;
	yylval.yysym = SymLookUp(yytext);
	return(IDENTIFIER) ;
    }

    // tell world about unknown character then
    // carry on as if nothing happened.

    cerr << "Unrecognized character '" << *pbuff << "'\n" ;
    pbuff++ ;
    goto _yytop ;
}

Operator *Equal    = new Operator (EQUAL) ;
Operator *Function = new Operator (FUNCTION) ;
Operator *Band	   = new Operator (BAND)  ;
Operator *Bor	   = new Operator (BOR)   ;
Operator *Bxor	   = new Operator (BXOR)  ;
Operator *Lsh	   = new Operator (LSH)   ;
Operator *Rsh	   = new Operator (RSH)   ;
Operator *Mod	   = new Operator (MOD)   ;
Operator *Power    = new Operator (POWER) ;
Operator *Star	   = new Operator (STAR)  ;
Operator *Slash    = new Operator (SLASH) ;
Operator *Plus	   = new Operator (PLUS)  ;
Operator *Minus    = new Operator (MINUS) ;

struct FuncAssc  {
    double (*Func) (double) ;
    Symbol  *Fsym	    ;
}   FuncTbl[]	=   {
    sin  , SymLookUp("sin") ,
    cos  , SymLookUp("cos") ,
    fabs , SymLookUp("abs") ,
    tan  , SymLookUp("tan") ,
    acos , SymLookUp("acos"),
    asin , SymLookUp("asin"),
    atan , SymLookUp("atan"),
    log  , SymLookUp("log") ,
    log10, SymLookUp("log10")
};

#define FTBLSZ	9

float	CallFunc    ( Symbol *Fname, float parm ) {

    for ( int i = 0 ; i < FTBLSZ ; i++ ) {
	if ( *FuncTbl[i].Fsym == *Fname )
	    return ((float) (*FuncTbl[i].Func)((double)parm)) ;
    }

    cerr << "Udefined function '" ;
    ((Identifier *) Fname)->PrintName(cerr) ;
    cerr << "'\n" ;
    return (float) 0 ;
}

void yyerror (char *s) {
    yyerrorflg = 1 ;
    printf(s) ;
}

void main() {
    printf("[%d] ",nc) ;
    while(yyparse()) ;
}
