//----------------------------------------------------------------------------
// ObjectWindows - (C) Copyright 1991, 1993 by Borland International
//----------------------------------------------------------------------------
//
// Amended by Ian Spencer 1994
//
#include <owl\owlpch.h>
#include <owl\applicat.h>
#include <owl\dialog.h>
#include <owl\framewin.h>
#include <owl\edit.h>
#include <owl\checkbox.h>
#include <owl\validate.h>
#include <string.h>  // for strcpy and strcat
#include <stdlib.h>  // for atoi
#include <ctype.h>   // for isdigit and isalpha
#include "edialog.h"
#include "execdlg.h"


#define MAXNAMELEN  35
#define MAXSSLEN    12
#define MAXIDLEN    4
#define MAXDEPTLEN  7
#define MAXSECLEN   3

struct TEmployeeStruct {
  char NameEdit[MAXNAMELEN];
  char SSEdit[MAXSSLEN];
  char IDEdit[MAXIDLEN];
  char DeptEdit[MAXDEPTLEN];
  char SecEdit[MAXSECLEN];
  BOOL FullTime;
  BOOL Perm;
  BOOL Exempt;
};

//----------------------------------------------------------------------------
// Note different ancestor

class TEmployeeDlg : public TEDialog {
  public:
	 TEmployeeDlg(TWindow* parent, const char* name, TEmployeeStruct& transfer);
	 void Help();
	 BOOL PreProcessMsg(MSG& msg);
	DECLARE_RESPONSE_TABLE(TEmployeeDlg);
};

TEmployeeDlg::TEmployeeDlg(TWindow* parent, const char* name, TEmployeeStruct& transfer)
  : TEDialog(parent, name)
	 // note slightly derivative ancestor
  {
  TWindow::Attr.AccelTable = EMPLOYEE_ACCELERATORS;
  TEdit* edit;
  edit = new TEdit(this, 101, sizeof(transfer.NameEdit));
  edit->SetValidator(new TFilterValidator("A-Za-z. "));
  edit = new TEdit(this, 102, sizeof(transfer.SSEdit));
  edit->SetValidator(new TPXPictureValidator("###-##-####"));
  edit = new TEdit(this, 103, sizeof(transfer.IDEdit));
  edit->SetValidator(new TRangeValidator(1, 999));
  edit = new TEdit(this, 104, sizeof(transfer.DeptEdit));
  edit->SetValidator(new TPXPictureValidator("Sales,Dev,Mfg"));
  edit = new TEdit(this, 105, sizeof(transfer.SecEdit));
  edit->SetValidator(new TPXPictureValidator("11,12,13,14,15"));
  new TCheckBox(this, 106, 0);
  new TCheckBox(this, 107, 0);
  new TCheckBox(this, 108, 0);

  TransferBuffer = (void far*)&transfer;
}
void TEmployeeDlg::Help()
	{
		MessageBox("This could be WINHELP but isn't...","Help");
	}
BOOL TEmployeeDlg::PreProcessMsg(MSG & msg)
	{
		if (msg.message == WM_KEYDOWN &&
			msg.wParam == VK_RETURN)
			{
				HWND Control = ::GetFocus();
				if ( Control && !(
											( ::SendMessage(Control, WM_GETDLGCODE, 0, 0) &
											(DLGC_DEFPUSHBUTTON | DLGC_UNDEFPUSHBUTTON))
										)
					)
					msg.wParam = VK_TAB;
			}
		return TDialog::PreProcessMsg(msg);
	}
DEFINE_RESPONSE_TABLE1(TEmployeeDlg, TEDialog)
  EV_COMMAND(CM_HELP, Help),
  EV_CHILD_NOTIFY(IDHELP,BN_CLICKED,Help),
END_RESPONSE_TABLE;
//----------------------------------------------------------------------------

class TTestWindow : public TFrameWindow {
  public:
	 TTestWindow(TWindow* parent, const char* title);
	 void CmEmpInput();
	 void CmEmpInputModally();
	BOOL IdleAction(long count);

  private:
	 TEmployeeStruct EmployeeStruct;

  DECLARE_RESPONSE_TABLE(TTestWindow);
};

DEFINE_RESPONSE_TABLE1(TTestWindow, TFrameWindow)
  EV_COMMAND(CM_EMPINPUT, CmEmpInput),
  EV_COMMAND(CM_EMPINPUTMODALLY, CmEmpInputModally), // my version
END_RESPONSE_TABLE;


TTestWindow::TTestWindow(TWindow* parent, const char* title)
  : TFrameWindow(parent, title),
	 TWindow(parent, title)
{
  AssignMenu(200);
  memset(&EmployeeStruct, 0, sizeof EmployeeStruct);
}

void
TTestWindow::CmEmpInput()
{
  char empInfo[sizeof(TEmployeeStruct)+5+1];

  if (TEmployeeDlg(this,"EMPLOYEEINFO", EmployeeStruct).Execute() == IDOK) {
	 strcpy(empInfo, EmployeeStruct.NameEdit);
	 strcat(empInfo, "\n");
	 strcat(empInfo, EmployeeStruct.SSEdit);
	 strcat(empInfo, "\n");
	 strcat(empInfo, EmployeeStruct.IDEdit);
	 strcat(empInfo, "\n");
	 strcat(empInfo, EmployeeStruct.DeptEdit);
	 strcat(empInfo, "\n");
	 strcat(empInfo, EmployeeStruct.SecEdit);
	 strcat(empInfo, "\n");
	 strcat(empInfo, EmployeeStruct.FullTime ? "FullTime " : "PartTime ");
	 strcat(empInfo, EmployeeStruct.Perm ? "Permanent " : "Temporary ");
	 strcat(empInfo, EmployeeStruct.Exempt ? "Exempt " : "NonExempt ");
	 MessageBox(empInfo, "Information Stored", MB_OK);
  }
}
BOOL TTestWindow::IdleAction(long count)
	{
		 static char ch[5] = {"|/-\\"};
		 static int i = 0;
		 TClientDC dc(*this);
		 dc.TextOut(20,20,&ch[i++],1);
		 if (i == 4) i = 0;
		 return TFrameWindow::IdleAction(count);
	}

void
TTestWindow::CmEmpInputModally()
{
  char empInfo[sizeof(TEmployeeStruct)+5+1];

  if (TEmployeeDlg(this,"EMPLOYEEINFO", EmployeeStruct).Execute(MB_TASKMODAL) == IDOK) {
	 strcpy(empInfo, EmployeeStruct.NameEdit);
	 strcat(empInfo, "\n");
	 strcat(empInfo, EmployeeStruct.SSEdit);
	 strcat(empInfo, "\n");
	 strcat(empInfo, EmployeeStruct.IDEdit);
	 strcat(empInfo, "\n");
	 strcat(empInfo, EmployeeStruct.DeptEdit);
	 strcat(empInfo, "\n");
	 strcat(empInfo, EmployeeStruct.SecEdit);
	 strcat(empInfo, "\n");
	 strcat(empInfo, EmployeeStruct.FullTime ? "FullTime " : "PartTime ");
	 strcat(empInfo, EmployeeStruct.Perm ? "Permanent " : "Temporary ");
	 strcat(empInfo, EmployeeStruct.Exempt ? "Exempt " : "NonExempt ");
	 MessageBox(empInfo, "Information Stored", MB_OK);
  }
}

//----------------------------------------------------------------------------

class TValidateApp : public TApplication {
  public:
	 TValidateApp() : TApplication("ValidateApp") {}
	 void InitMainWindow() {
		EnableCtl3d();
		MainWindow = new TTestWindow(0, "Validate Dialog Input");
	 }


};
int
OwlMain(int /*argc*/, char* /*argv*/ [])
{
  return TValidateApp().Run();
}