/*  Project enable
    
    Copyright  1994. All Rights Reserved.

    SUBSYSTEM:    enable.apx Application
    FILE:         testdlg.cpp
    AUTHOR:       Lindsay Mathieson


    OVERVIEW
    ========
    Source file for implementation of TTestDialog (TDialog).      
*/

#include <owl\owlpch.h>
#pragma hdrstop

#include "testdlg.h"


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(TTestDialog, TEnableDialog)
//{{TTestDialogRSP_TBL_BEGIN}}
    EV_BN_CLICKED(IDOK, okBNClicked),
//{{TTestDialogRSP_TBL_END}}
	EV_COMMAND_ENABLE(IDOK,CeOk),
	EV_COMMAND_ENABLE(IDCANCEL,CeCancel),
	EV_COMMAND_ENABLE(IDC_AMOUNT,CeAmount),
END_RESPONSE_TABLE;


//{{TTestDialog Implementation}}


TTestDialog::TTestDialog (TWindow* parent, TResId resId, TModule* module):
    TEnableDialog(parent, resId, module)
{
    // INSERT>> Your constructor code here.
	new TButton(this,IDOK);
	new TButton(this,IDCANCEL);
	new TButton(this,IDC_AMOUNT);

	AddHelp(IDOK,"Ok\r\nDont Press this\r\nUntil 'Enable Ok' is checked\r\nand Amount is filled in");
	AddHelp(IDCANCEL,"Cancel Button");
	AddHelp(IDC_AMOUNT,"Enter Amount");
	AddHelp(IDC_ENABLEAMOUNT,"Enables Amount Data Entry");
	AddHelp(IDHELP,"This is a really really really really long line");
}


TTestDialog::~TTestDialog ()
{
    Destroy();
    // INSERT>> Your destructor code here.

}


void TTestDialog::okBNClicked ()
{
	// INSERT>> Your code here.
	CmOk();

}

void TTestDialog::CeOk(TCommandEnabler& ce)
{
	BOOL enable = IsDlgButtonChecked(IDC_ENABLEOK) &&
		::GetWindowTextLength(GetDlgItem(IDC_AMOUNT)) > 0;
	ce.Enable(enable);
};

void TTestDialog::CeCancel(TCommandEnabler& ce)
{
	BOOL enable = IsDlgButtonChecked(IDC_ENABLECANCEL);
	ce.Enable(enable);
	ce.SetText(::GetWindowTextLength(GetDlgItem(IDC_AMOUNT)) > 0 ? "Close" : "Cancel");
};

void TTestDialog::CeAmount(TCommandEnabler& ce)
{
	BOOL enable = IsDlgButtonChecked(IDC_ENABLEAMOUNT);
	ce.Enable(enable);
};

