#ifndef __ENABLEDL_H
#define __ENABLEDL_H

//*********
//
//	Class:TControlHelpData
//
// 	Description:
//	Support class for managing balloon help data
//
//  Last modified date:4/5/95
//   Last modified by:Lindsay Mathieson
//

#include <classlib\arrays.h>
#include <cstring.h>

class TControlHelpData
{
	public:
	int		Id;
	string	text;

	TControlHelpData() : Id(-1), text("") {}
	TControlHelpData(int id, string s) : Id(id), text(s) {}
	~TControlHelpData()	{}

	void Set(string s)
	{
		text = s;
	};

	int operator == (const TControlHelpData& d)	{return Id == d.Id;}
	int operator <  (const TControlHelpData& d)	{return Id <  d.Id;}
};


//
//  Class:TBHelpData
//
//  Description:
//	Maintains list of help data for controls
//
//  Last modified date:4/5/95
//  Last modified by:Lindsay Mathieson
//

class TBHelpData
{
	public:
	TISArrayAsVector<TControlHelpData>	Help;

	TBHelpData()	: Help(0,0,1) {Help.OwnsElements(1);}


	inline TControlHelpData *FindHelp(int id)
	{
		TControlHelpData tmp(id,"");
		int idx = Help.Find(&tmp);
		return (idx == INT_MAX) ? NULL : Help[idx];
	};

	void AddHelp(int id,string text)
	{
		TControlHelpData *data = FindHelp(id);
		if (data)
			data->Set(text);
		else
		{
			data = new TControlHelpData(id,text);
			Help.Add(data);
		};
	};
};

class TMixInEnableDialog : public virtual TWindow
{
	private:
	BOOL executingModally;
	HWND* wnds;

	protected:
	TBHelpData	BHelp;

	public:
	TMixInEnableDialog();
	virtual int 	ExecuteModally();
	virtual void 	DoDestroy(int retValue = IDCANCEL);
	virtual void 	DoCloseWindow(int retValue = IDCANCEL);
	virtual BOOL 	DoIdleAction(long idleCount);

	// Balloon Help Stuff
	inline void AddHelp(int id, string text)	{BHelp.AddHelp(id,text);}
};

#define MIXIN_ENABLE_FUNCS \
	virtual int Execute()								{return ExecuteModally();}\
	virtual void Destroy(int retValue = IDCANCEL) 		{DoDestroy(retValue);}\
	virtual void CloseWindow(int retValue = IDCANCEL)	{DoCloseWindow(retValue);}\
	virtual BOOL IdleAction(long idleCount)				{return DoIdleAction(idleCount);}

class TEnableDialog : public TDialog, public TMixInEnableDialog
{
	public:
	TEnableDialog(TWindow* parent, TResId resId, TModule* module = 0) :
		TDialog(parent,resId,module),TMixInEnableDialog()
	{}

    MIXIN_ENABLE_FUNCS;
};


#endif
