
#include <owl\owlpch.h>
#pragma hdrstop
#include "enabledl.h"

//
// Structure for holding windows to disable
//
struct TEnumInfo {
  short     Count;
  HWND far* Wnds;
};
//
// Simplified from TApplication::DisableWnds
//
// Note this is called before the dialog is created and does not
// disable the windows
//
// Firstly called to count up the windows to be stored
// then called to save the windows
//
BOOL far _export _pascal EnumerateActiveWnds(HWND wnd, TEnumInfo* info)
{
	if (!(::GetWindowLong(wnd, GWL_STYLE) & WS_CHILD))
	{
		if (::IsWindowEnabled(wnd))
			if (!info->Wnds) // counting windows to determine buffer size
				info->Count++;
			else
				*(info->Wnds++) = wnd;
	}
	return TRUE;
}

TMixInEnableDialog::TMixInEnableDialog() :
	executingModally(FALSE),wnds(NULL)
{
	if (TYPESAFE_DOWNCAST(Parent,TMDIClient))
    	SetParent(GetApplication()->GetMainWindow());
};

//
// This is it. Note that this assumes WS_VISIBLE is set for the dialog
// Execute always shows the dialogs
//
int TMixInEnableDialog::ExecuteModally()
{
	TEnumInfo ei = { 0, 0 };
	wnds = 0;

	// Set modal state
	//
	if (!EnumTaskWindows(GetCurrentTask(), (WNDENUMPROC)EnumerateActiveWnds,
							(LPARAM)(TEnumInfo far*)&ei))
		return -1;

	// Allocate list of windows to disable, disable windows that are
	// enabled and then stuff them into the list.
	//
	ei.Wnds = wnds = new HWND[ei.Count + 1];
	memset(wnds, 0, sizeof(HWND)*(ei.Count + 1));

	EnumTaskWindows(GetCurrentTask(), (WNDENUMPROC)EnumerateActiveWnds,
							 (LPARAM)(TEnumInfo far*)&ei);

	if (Create())
	{
		executingModally = TRUE;
		if (wnds)
		for (HWND* wnd = wnds; *wnd; wnd++)
			::EnableWindow(*wnd, FALSE);
		return GetApplication()->MessageLoop();
	}
	return -1;
}

//
// If executing Modally, ensure the fake method of closing
// is used. Normally Modal and Modeless dialogs close in different
// ways. (Especially modal dialog OWL objects are not destroyed).
//
void TMixInEnableDialog::DoDestroy(int Return)
{
	if (executingModally)
	{
		//
		// Re-enable window(s) that are disabled in BeginModal()
		// before the dialog is destroyed so that application remains active
		//
		if (wnds)
			for (HWND* wnd = wnds; *wnd; wnd++)
				::EnableWindow(*wnd, TRUE);
		delete wnds;

		executingModally = FALSE;
		GetApplication()->EndModal(Return);
	}
	TWindow::Destroy(Return);
}

void TMixInEnableDialog::DoCloseWindow(int returnValue)
{
	if (executingModally) // get my variation
	{
		if (CanClose())
		{
			TransferData(tdGetData);
			Destroy(returnValue);
		}
	}
	else
		TWindow::CloseWindow(returnValue);
}

//*********************************************
// TControlEnabler
class TControlEnabler : public TCommandEnabler
{
	public:
	TControlEnabler(TControl *cntrl, HWND hwndReceiver) :
		TCommandEnabler(cntrl->Attr.Id,hwndReceiver),
		Cntrl(cntrl)
	{
	};

	virtual void Enable(BOOL enable);
	virtual void SetText(const char far *str);
	virtual void SetCheck(int check);

	protected:
		TControl *Cntrl;
};

void TControlEnabler::Enable(BOOL enable)
{
	TCommandEnabler::Enable(enable);
    Cntrl->EnableWindow(enable);
};

void TControlEnabler::SetText(const char far *str)
{
	int length = Cntrl->GetWindowTextLength() + 1;
	char *text = new char[length];
	Cntrl->GetWindowText(text,length);
	if (strcmp(str,text))
		Cntrl->SetWindowText(str);
	delete [] text;
};

void TControlEnabler::SetCheck(int check)
{
	Cntrl->HandleMessage(BM_SETSTYLE,check,MAKELPARAM(TRUE,0));
	if (check == BS_DEFPUSHBUTTON)
    	Cntrl->Parent->HandleMessage(DM_SETDEFID,WPARAM(Cntrl->Attr.Id));
};

static void DoEnabling(TWindow *ctl, void *)
{
	TControl *Cntrl = TYPESAFE_DOWNCAST(ctl,TControl);

	if (Cntrl)
	{
		TWindow *parent = Cntrl->Parent;
		TControlEnabler enabler(Cntrl,*parent);
		parent->HandleMessage(WM_COMMAND_ENABLE,0,LPARAM(&enabler));
	};
};

class THelpWindow : public TWindow
{
	private:
	TControlHelpData	*Help;
	HWND				Child;

	public:
	THelpWindow(TWindow *parent,TControlHelpData *help,HWND child) :
		TWindow(parent,""),Help(help),Child(child)
	{
		Attr.Style = WS_CHILD;
		Attr.Style &= ~(WS_CAPTION | WS_VISIBLE);
        Attr.ExStyle = WS_EX_TOPMOST;
		//SetBkgndColor(TColor::LtYellow);
	};

	inline int HelpId()	{return ((Help) ? Help->Id : -1);}

	void GetWindowClass(WNDCLASS& wndClass)
	{
		TWindow::GetWindowClass(wndClass);
        wndClass.hbrBackground = NULL;
	};

	void SetupWindow();
	virtual void Paint(TDC& dc, BOOL erase, TRect& rect);

};

void THelpWindow::SetupWindow()
{
	TWindow::SetupWindow();

	// calculate window rect
	TWindowDC	dc(HWindow);
	TEXTMETRIC	tm;
	dc.GetTextMetrics(tm);

	TRect r(0,0,tm.tmAveCharWidth * 10,tm.tmHeight);


	// figure out text width
	dc.DrawText(Help->text.c_str(),-1,r,DT_CALCRECT | DT_LEFT | DT_NOPREFIX);

	// add width of borders
	r.right += 4;
	r.bottom += 4;

	// Figure out position
	TRect cr;
	::GetWindowRect(Child,&cr);
	TPoint p = cr.TopLeft();
	ScreenToClient(p);
	r.Offset(p.x,p.y);
	int h = r.Height();
	if (r.top - h - 2 >= 0)
		r.Offset(0,-h - 2);
	else if (r.bottom + h + 2 <= Parent->GetClientRect().bottom)
		r.Offset(0,+h + 2);
	else
	{
		// high as possible
		int y = r.top;
		r.Offset(0,-y);
	};
	// check right margin
	if (r.right > Parent->GetClientRect().right)
	{
		int cx = r.right - Parent->GetClientRect().right;
		r.Offset(-cx,0);
	};


	SetWindowPos(NULL,r,SWP_SHOWWINDOW | SWP_NOZORDER);
	ShowWindow(SW_SHOW);
};

void THelpWindow::Paint(TDC& dc, BOOL erase, TRect& rect)
{
	TRect r = GetClientRect();

	TBrush b(TColor::LtYellow);
	dc.SelectObject(b);
	dc.SetBkColor(TColor::LtYellow);
	dc.Rectangle(r);
	r.Inflate(-2,-2);
	dc.DrawText(Help->text.c_str(),-1,r,DT_LEFT | DT_NOPREFIX);
};

static THelpWindow *HelpWindow = NULL;
static DWORD tick = 0;

BOOL TMixInEnableDialog::DoIdleAction(long idleCount)
{
	if (! idleCount)
		ForEach(DoEnabling);

	// check balloon help
	TPoint pos;
	GetCursorPos(pos);
    ScreenToClient(pos);
	HWND child = ChildWindowFromPoint(pos);
	int Id = ::GetWindowWord(child,GWW_ID);

	if (Id <= 0 || (HelpWindow && HelpWindow->HelpId() == Id))
	{
		if (HelpWindow && HelpWindow->HelpId() != Id)
		{
			HelpWindow->Destroy();
			delete HelpWindow;
			HelpWindow = NULL;
			tick = 0;
		};

		return TWindow::IdleAction(idleCount);
	}

	if (HelpWindow)
	{
		HelpWindow->Destroy();
		delete HelpWindow;
		HelpWindow = NULL;
		tick = 0;
	};

	TControlHelpData *Data = BHelp.FindHelp(Id);
	if (! Data)
		return TWindow::IdleAction(idleCount);

	// New Control Has Help
	// delay initial help
	if (! tick)
		tick = GetTickCount();
	// Something odd going on here
    // tickcount does not seem to be updating
	//if (GetTickCount() - tick < 1000L)
	//	return TWindow::IdleAction(idleCount);

	HelpWindow = new THelpWindow(this,Data,child);
	HelpWindow->Create();
    tick = 0;

	return TWindow::IdleAction(idleCount);
};

