
/*  TEST.C  */

/**************************************************************************/
/****  This is the TEST and sample program for DOCMEM.C.               ****/
/**************************************************************************/
/****  Written and released into the public domain 1995 by Brian Reed  ****/
/****  (aka Doc Raster)  CIS 73503,3364 or 73503.3364@compuserve.com   ****/
/**************************************************************************/
/****  Use at your own risk.                                           ****/
/**************************************************************************/

#include <stdio.h>
#include <conio.h>
#include "docmem.h"


int main()
{
unsigned int i;
unsigned int size=500;
char _far *tester2;
char _far *tester;


  clrscr();


  //  Start the memory checker.
  DOCstart();


  //  Try and free a null pointer.  Will list an error in log.
  DOCerr_set(DOC_OK);                    // clear the error for each test
  printf("\nRunning Tester 1\n");
  DOCfarfree((void _far *)0);
  printf("%s\n", DOCerr_string(DOCerr_last()));
  if (DOCerr_last() == DOC_LOWADDR)
    printf("(DOCMEM TEST is correct.)\n");
  else
    printf("(DOCMEM TEST error!  Result of test is incorrect.)\n");


  //  Assert (check) a low pointer.  This will list an error in log.
  DOCerr_set(DOC_OK);                    // clear the error for each test
  printf("\nRunning Tester 2\n");
  DOCfarassert("Tester 2 label", (void _far *)6);
  printf("%s\n", DOCerr_string(DOCerr_last()));
  if (DOCerr_last() == DOC_LOWADDR)
    printf("(DOCMEM TEST is correct.)\n");
  else
    printf("(DOCMEM TEST error!  Result of test is incorrect.)\n");


  //  Test an OK memory loop.  Will not list an error in log.
  DOCerr_set(DOC_OK);                    // clear the error for each test
  printf("\nRunning Tester 3\n");
  tester = DOCfarmalloc((long)size);
  if (tester) {
    for (i=0; i<size; i++)
      tester[i] = 0xFF;
    DOCfarfree(tester);
    printf("%s\n", DOCerr_string(DOCerr_last()));
  }
  else
    printf("Couldn't alloc for Tester 3\n");
  if (DOCerr_last() == DOC_OK)
    printf("(DOCMEM TEST is correct.)\n");
  else
    printf("(DOCMEM TEST error!  Result of test is incorrect.)\n");


  //  Test an OVERRUN memory loop.  Will list an error in log.
  DOCerr_set(DOC_OK);                    // clear the error for each test
  printf("\nRunning Tester 4\n");
  tester = DOCfarmalloc((long)size);
  if (tester) {
    for (i=0; i<size; i++)
      tester[i+1] = 0xFF;
    DOCfarfree(tester);
    printf("%s\n", DOCerr_string(DOCerr_last()));
  }
  else
    printf("Couldn't alloc for Tester 4\n");
  if (DOCerr_last() == DOC_OVERRUN)
    printf("(DOCMEM TEST is correct.)\n");
  else
    printf("(DOCMEM TEST error!  Result of test is incorrect.)\n");


  //  Test an UNDERRUN memory loop.  Will list an error in log.
  DOCerr_set(DOC_OK);                    // clear the error for each test
  printf("\nRunning Tester 5\n");
  tester = DOCfarmalloc((long)size);
  if (tester) {
    for (i=0; i<size; i++)
      tester[i-1] = 0xFF;
    DOCfarfree(tester);
    printf("%s\n", DOCerr_string(DOCerr_last()));
  }
  else
    printf("Couldn't alloc for Tester 5\n");
  if (DOCerr_last() == DOC_UNDERRUN)
    printf("(DOCMEM TEST is correct.)\n");
  else
    printf("(DOCMEM TEST error!  Result of test is incorrect.)\n");


  //  Assert a pointer that is not an exact allocation base, to see if
  //  DocMem can find its allocated block.  An pointer that points within
  //  a block you've allocated will not log an error.
  DOCerr_set(DOC_OK);                    // clear the error for each test
  printf("\nRunning Tester 6\n");
  tester = DOCfarmalloc((long)size);
  if (tester) {
    DOCfarassert("Tester 6", (void _far *)((char _far *)tester+(size/2)));
    DOCfarfree(tester);
    printf("%s\n", DOCerr_string(DOCerr_last()));
  }
  else
    printf("Couldn't alloc for Tester 6\n");
  if (DOCerr_last() == DOC_OK)
    printf("(DOCMEM TEST is correct.)\n");
  else
    printf("(DOCMEM TEST error!  Result of test is incorrect.)\n");


  //  Assert a pointer that is outside the allocation block (by just one
  //  byte!), to see if DocMem can tell it is invalid.  This out of range
  //  pointer will list an error in log.
  DOCerr_set(DOC_OK);                    // clear the error for each test
  printf("\nRunning Tester 7\n");
  tester = DOCfarmalloc((long)size);
  if (tester) {
    DOCfarassert("Tester 7 label", (void _far *)((char _far *)tester+size));
    DOCfarfree(tester);
    printf("%s\n", DOCerr_string(DOCerr_last()));
  }
  else
    printf("Couldn't alloc for Tester 7\n");
  if (DOCerr_last() == DOC_INVALID)
    printf("(DOCMEM TEST is correct.)\n");
  else
    printf("(DOCMEM TEST error!  Result of test is incorrect.)\n");


  // Now make 2 allocations and don't free them, so we can test DOCend too.
  DOCerr_set(DOC_OK);                    // clear the error for each test
  printf("\nRunning Tester 8  ");
  tester = DOCfarmalloc((long)size);
  tester2 = DOCfarmalloc((long)size);
  if (tester && tester2) {
    printf("(Memory allocated, left un-freed..)\n");
  }
  else
    printf("Couldn't alloc for Tester 8\n");


  //  Use the DOClog_write() function twice as a user message example.
  //  In this case, we're logging the pointer variable 'tester' and
  //  tester2.  Note that logging a pointer this way does NOT assert it.
  DOClog_write("log_write label 1", DOC_USER, tester);
  DOClog_write("log_write label 2", DOC_USER, tester2);


  // Closeup the memory checker.
  DOCend();


  // This goes with the last Tester.  We should be left with one
  // un-freed allocation.
  printf("%s\n", DOCerr_string(DOCerr_last()));
  if (DOCerr_last() == DOC_UNFREED)
    printf("(DOCMEM TEST is correct.)\n");
  else
    printf("(DOCMEM TEST error!  Result of test is incorrect.)\n");


  printf("\n<Press any key>\n");
  if (getch()==0)             /*  Soak up FUNC keys while we're at it.  */
    getch();
  return 0;
}

