/*
** AUDITV <container>
**
**	Login as volume auditor and list entries in the audit file.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia.
*/

extern unsigned _stklen = 8192;

# include <stdio.h>
# include <conio.h>
# include <io.h>

# include <dscontext.h>
# include <dslocale.h>
# include <dsconn.h>
# include <dsaudit.h>

struct  FTime   {
    unsigned    ft_tsec  : 5;   /* Two second interval */
    unsigned    ft_min   : 6;   /* Minutes */
    unsigned    ft_hour  : 5;   /* Hours */
} ;

struct  FDate   {
    unsigned    ft_day   : 5;   /* Days */
    unsigned    ft_month : 4;   /* Months */
    unsigned    ft_year  : 7;   /* Year */
} ;

int main(int argc, char * argv[])
{
	if (argc != 3){
		fprintf(stderr,"usage: AUDITV server volume\n") ;
		return 0 ;
		}
	DSLocale  dsLocale ;
	DSContext dsContext ;

	if (dsLocale.status()){
		printf("Cannot initialise unicode - 0x%X\n",dsLocale.status()) ;
		return 0 ;
		}
	if (dsContext.status()){
		printf("Cannot create context - 0x%X\n",dsContext.status()) ;
		return 0 ;
		}

	WORD		objectID ;
	char		buffer[1024] ;
	char		name  [256] ;
	WORD		retSize ;

	DSAudit dsAudit(dsContext,argv[1]) ;
	if (dsAudit.status()){
		printf("Cannot attach to server - 0x%X\n",dsAudit.status()) ;
		return 0 ;
		}
	char *	password = getpass("Audit password: ") ;

	if (dsAudit.GetVolumeNumber(argv[2],objectID)){
		printf("Cannot get number of volume - 0x%X\n",dsAudit.status()) ;
		return 0 ;
		}
	if (dsAudit.LoginAsVolumeAuditor(objectID,(BYTE*)password)){
		printf("Cannot login as auditor - 0x%X\n",dsAudit.status()) ;
		return 0 ;
		}
	dsAudit.InitAuditFileRead(0) ;
	if (dsAudit.status())
		printf("Initialisation failed - 0x%X\n",dsAudit.status()) ;

	WORD		count = 0 ;
	FTime *		pTime ;
	FDate *		pDate ;
	AuditRecord *	audit = (AuditRecord *) buffer ;

	while (dsAudit.ReadAuditingFileRecord(buffer,sizeof(buffer),retSize) == 0){
		if (retSize > 0){
			count ++ ;
			pDate = (FDate *) & audit->dosDate ;
			pTime = (FTime *) & audit->dosTime ;
			if (dsAudit.MapIDToName(audit->processUniqueID,name))
				sprintf(name,"0x%X",dsAudit.status()) ;

			printf("EventID           %d\n",audit->eventTypeID) ;
			printf("User ID           %08lX %s\n",audit->processUniqueID,name) ;
			printf("Time              %02u/%02u/%02u %02u:%02u:%02u\n",
					pDate->ft_day, pDate->ft_month,pDate->ft_year,
					pTime->ft_hour,pTime->ft_min,  pTime->ft_tsec*2) ;
			}
		}
	printf("\n%d records read\n",count) ;

	if (dsAudit.status())
		printf("Reading failed - 0x%X\n",dsAudit.status()) ;

	if (dsAudit.LogoutAsAuditor()){
		printf("Cannot logout as auditor - 0x%X\n",dsAudit.status()) ;
		return 0 ;
		}

	return 0 ;
}

