/*
** Change NDS Password
*/

# include <stdio.h>

# include <dslocale.h>
# include <dscontex.h>

int main(int argc, char * argv[])
{
	if (argc < 3 || argc > 4){
		fprintf(stderr,"usage: password object-name new-password [old-password]\n") ;
		return 0 ;
		}

	DSLocale	locale ;
	DSContext	context ;
	char *		oldPassword = (argc == 3) ? "xxxyyyzzzaaa" : argv[3] ;

	if (argc == 4){
		if (context.VerifyObjectPassword(argv[1],argv[3])){
			printf("Old password is invalid\n") ;
			return 0 ;
			}
		}
	else {
		if (context.GenerateObjectKeyPair(argv[1],oldPassword)){
			printf("Cannot change object key pair\n") ;
			return 0 ;
			}
		}

	if (context.ChangeObjectPassword(argv[1],oldPassword,argv[2]))
		printf("Error %x in changing password\n",context.status()) ;
	else
		printf("Password change successful\n") ;

	return 0 ;
}
