/*
** LISTPART <server> [context]
**
**	List partitions held on the server.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia.
*/

# define DSCPP_IOSTREAM

# include "dslocale.h"
# include "dspartit.h"
# include "dsiterat.h"

class DSListIteration : public DSIteration
{
protected:
	WORD		Count ;
public:
	NWDSCCODE	InitLoop()
				{ return Count = 0 ; }
	NWDSCCODE	InitObject(NWPSTR object, void *)
				{ cout << "Server " << object << endl ;
				  return 0 ; }
	NWDSCCODE	SetAttrName(NWPSTR object, NWSYNTAX_ID type)
				{ cout << ++Count << ". " << object
				       << "\t" << type << endl ;
				  return 0 ; }
} ;

int main(int argc, char * argv[])
{
DSLocale	dsLocale ;
DSListIteration	dsListIteration ;
DSPartition	dsPartition(argc == 3 ? argv[2] : "") ;

	if (argc < 2 || argc > 3){
		cerr << "Usage: LISTPART server [context]\n" ;
		return 0 ;
		}
	if (dsLocale.status() || dsPartition.status()) return 0 ;

	dsPartition.ListPartitions(argv[1],& dsListIteration) ;

	return 0 ;
}
