/*
** LIST [context]
**
**	List the object in the context container.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia.
*/

# define DSCPP_IOSTREAM

# include "dslocale.h"
# include "dsbuffer.h"
# include "dsiterat.h"

class DSListIteration : public DSIteration
{
protected:
	WORD		Count ;
public:
	NWDSCCODE	InitLoop()
				{ return Count = 0 ; }
	NWDSCCODE	InitObject(NWPSTR object, void * info)
				{ cout << ++Count << "." << object << "\n" ;
				  return 0 ; }
} ;

int main(int argc, char * argv[])
{
DSLocale	dsLocale ;
DSListIteration	dsListIteration ;
DSBuffer	dsBuffer(argc == 2 ? argv[1] : "") ;
char		context[MAX_DN_BYTES] ;

	if (dsLocale.status() || dsBuffer.status()) return 0 ;

	dsBuffer.GetContext(context) ;
	cout << "Objects found under \"" << context << "\"\n" ;
	dsBuffer.List("",& dsListIteration) ;

	return 0 ;
}
