/*
** WSEARCH [search pattern]
**
**	Search for all uses using [search pattern].
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia.
*/

# define DSCPP_IMPORT
# define DSCPP_WINDOWS

# include "dslocale.h"
# include "dsbuffer.h"
# include "dsiterat.h"

# include <string.h>
# include <strstrea.h>

# define PHONE_SIZE	 32
# define LOGIN_SIZE	 64
# define FULL_SIZE	127

NWPSTR	UserObjectAttributes[] = { "CN", "Full Name", "Telephone Number", 0 } ;

class DSUserObject : public DSIteration
{
	char		LoginName[LOGIN_SIZE] ;
	char		FullName [FULL_SIZE ] ;
	char		Telephone[PHONE_SIZE] ;
	WORD		Index ;
public:
			DSUserObject() { ; }

	NWDSCCODE	InitObject(NWPSTR object, void * info)
				{ LoginName[0] = FullName[0] = Telephone[0] = 0 ;
				  return DSIteration::InitObject(object,info) ; }
	NWDSCCODE	SetAttrName(NWPSTR attrName, NWSYNTAX_ID syntax) ;

	NWDSCCODE	SetAttrValue(NWSYNTAX_ID syntax, void * data) ;

	NWDSCCODE	ExitObject(NWPSTR object) ;

friend	ostream &	operator<<(ostream & s, DSUserObject & u) ;
} ;

NWDSCCODE DSUserObject::SetAttrName(NWPSTR attrName, NWSYNTAX_ID)
{
	for (Index = 0 ; UserObjectAttributes[Index] ; Index++)
		if (stricmp(UserObjectAttributes[Index],attrName) == 0)	break ;
	return 0 ;
}

NWDSCCODE DSUserObject::SetAttrValue(NWSYNTAX_ID, void * data)
{
	switch (Index) {
	    case 0:
		strncpy(LoginName,(NWPSTR) data,LOGIN_SIZE) ; break ;
	    case 1:
		strncpy(FullName, (NWPSTR) data,FULL_SIZE) ;  break ;
	    case 2:
		strncpy(Telephone,(NWPSTR) data,PHONE_SIZE) ; break ;
	    }
	return 0 ;
}

NWDSCCODE DSUserObject::ExitObject(NWPSTR object)
{
char		buffer[256] ;
ostrstream	stream(buffer,sizeof(buffer)) ;

	stream << object << endl << * this << '\0' ;
	MessageBox(0,stream.str(),"Search Users",MB_OK) ;
	return 0 ;
}

ostream & operator<<(ostream & s, DSUserObject & user)
{
	return s << "Login\t" << user.LoginName << "\n"
		 << "Name\t"  << user.FullName  << "\n"
		 << "Phone\t" << user.Telephone << "\n" ;
}

int PASCAL WinMain(HINSTANCE,HINSTANCE,LPSTR cmdLine,int)
{
DSLocale	dsLocale ;
DSBuffer	dsBuffer ;
DSUserObject	dsUserObject ;

	if (dsLocale.status())
		MessageBox(0,"Cannot load Unicode","Error",MB_OK) ;
	if (dsBuffer.status())
		MessageBox(0,"Cannot initialise buffer","Error",MB_OK) ;

	LPSTR string = (strlen(cmdLine)) ? cmdLine : "*" ;

	dsBuffer.InitBuf(DSV_SEARCH) ;
	dsBuffer.PutAttrName(UserObjectAttributes) ;
	dsBuffer.InitFilter() ;
	dsBuffer.AddFilterToken(FTOK_ANAME,"Object Class",SYN_CLASS_NAME) ;
	dsBuffer.AddFilterToken(FTOK_EQ) ;
	dsBuffer.AddFilterToken(FTOK_AVAL,"USER",SYN_CLASS_NAME) ;
	dsBuffer.AddFilterToken(FTOK_AND) ;
	dsBuffer.AddFilterToken(FTOK_ANAME,"CN",SYN_CLASS_NAME) ;
	dsBuffer.AddFilterToken(FTOK_EQ) ;
	dsBuffer.AddFilterToken(FTOK_AVAL,string,SYN_CI_STRING) ;
	dsBuffer.ExitFilter() ;

	if (dsBuffer.Search("",DS_SEARCH_SUBTREE,1,1,0,&dsUserObject)){
		MessageBox(0,"Cannot search directory","Error",MB_OK) ;
		return 0 ;
		}
	return 0 ;
}
