/*
** OBJECT <common name> [context]
**
**	Read the address fields of an NDS object.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia.
*/

# define DSCPP_IOSTREAM

# include "dslocale.h"
# include "dsobject.h"
# include "dsvaddr.h"

# include <string.h>
# include <stdio.h>

/*
** dsAddrAttrNames[]		Null terminated list of attribute names present
**				in the DSAddrObject. The order of these names
**				is important and must be the same as used by
**				the function FindAttribute().
*/

NWPSTR	dsAddrAttrNames[] = { "Network Address",
			      "Postal Address",
			      "Email Address",
			      0 } ;

/*
** dsAddrAttrCount[]		Number of attribute fields in the DSAddrObject
**				for each attribute listed in dsAddrAttrNames[].
*/

WORD	dsAddrAttrCount[] = { 1, 1, 1, 0 } ;

/*
** Class DSAddrObject
**
**	Used to create and read objects from the NDS.
*/

class DSAddrObject : public DSObject
{
protected:
    DSValue *		FindAttribute(WORD attrIndex, WORD valueIndex) ;

    NWPSTR *		AttributeNames()
				{ return dsAddrAttrNames ; }
    WORD *		AttributeCount()
				{ return dsAddrAttrCount ; }
    NWPSTR		ClassName()
				{ return "USER" ; }
public:
    DSVNetAddress	Net ;
    DSVEmailAddress	Email ;
    DSVPostalAddress	Postal ;

			DSAddrObject() {  }
} ;

/*
** DSValue * DSAddrObject::FindAttribute(WORD attrIndex, WORD)
**
**	Given an attribute index and a value index, return a pointer to the
**	DSValue object responsible for that attribute/value pair.
*/

DSValue * DSAddrObject::FindAttribute(WORD attrIndex, WORD)
{
	switch (attrIndex) {
	    case 0:
		return & Net ;
	    case 1:
		return & Postal ;
	    case 2:
		return & Email ;
	    }
	return 0 ;
}

/*
** int main(int argc, char * argv[])
*/

int main(int argc, char * argv[])
{
	if (argc < 2 || argc > 3){
		cerr << "Usage: ADDRESS common_name [context]\n" ;
		return 0 ;
		}
	DSLocale	dsLocale ;
	DSBuffer	dsBuffer(argc == 3 ? argv[2] : "") ;
	DSAddrObject	oldAddress, newAddress ;

	if (dsLocale.status() || dsBuffer.status()){
		cerr << "ADDRESS: Cannot initialise Unicode\n" ;
		return 0 ;
		}
	if (oldAddress.ReadObject(argv[1],& dsBuffer)){
		cerr << "Cannot read user \"" << argv[1] << "\""
			" Error " << hex << dsBuffer.status() << "\n" ;
		return 0 ;
		}
	cout << "\nOld address values\n" << oldAddress ;

	newAddress = oldAddress ;

	cout << "\nCopied address\n" << newAddress ;

	char * postalAddress =	"Novell Australia\n"
				"201 Miller Street\n"
				"North Sydney\n"
				"New South Wales\n"
				"2060\n"
				"Australia\n" ;

	newAddress.Net    << Address("0101d5c0:008029e0f8a3:5003") << Type(0) ;
	newAddress.Email  << Address("JBUCKLE@NOVELL.COM") << Type(0) ;
	newAddress.Postal << Address(postalAddress) ;

	if (newAddress == oldAddress){
		cout << "Object has not been modified\n" ;
		return 0 ;
		}
	if (newAddress.WriteObject(argv[1],& dsBuffer,& oldAddress)){
		cout << "Cannot modify user \"" << argv[1] << "\""
			" Error " << hex << dsBuffer.status() << "\n" ;
		return 0 ;
		}

	return 0 ;
}