/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSVMULTI.CPP - October 1994
**
**	Definition of the DSVMultiValue class.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# include "dsdefs.h"
# include "dsvmulti.h"

DSValue * DSVList<DSValue>::create(DSValue * value)
{
	return DSValue::create(value->syntax(),value->data()) ;
}

/*
** NWDSCCODE DSVMultiValue::assign(NWSYNTAX_ID syntax, void * value)
**
**	Append the NDS value given by syntax and value onto the end of
**	multivalue list.
*/

NWDSCCODE DSVMultiValue::assign(NWSYNTAX_ID syntaxID, void * value)
{
	if (Syntax == 0)
		Syntax = syntaxID ;
	else
		if (Syntax != syntaxID) return DSCPP_WRONG_TYPE ;

	return List.assign(DSValue::create(syntaxID,value)) ;
}

/*
** NWDSCCODE DSVMultiValue::release(int index = DSCPP_DEF_INDEX)
*/

NWDSCCODE DSVMultiValue::release(int index)
{
	if (index == DSCPP_DEF_INDEX) Syntax = 0 ;

	return List.release(index) ;
}

/*
** NWDSCCODE DSVMultiValue::compare(DSValue * value)
**
**	Compare DSVMultiValue object with a DSValue object. Return TRUE(1) if
**	the DSValue object is in the list, FALSE(0) otherwise. Return a
**	negative value for an error.
*/

NWDSCCODE DSVMultiValue::compare(DSValue * value)
{
	if (checkTypeAndSyntax(value,dsValueTypeArray[(WORD)Syntax]))
		return checkTypeAndSyntax(value,dsValueTypeArray[(WORD)Syntax]) ;

	for (DSValueIterator iter(List) ; iter() ; iter.next())
		if (iter()->compare(value) > 0) return 1 ;

	return 0 ;
}

#ifdef DSCPP_IOSTREAM
/*
** ostream & DSVMultiValue::stream(ostream & s)
*/

ostream & DSVMultiValue::stream(ostream & s)
{
	for (DSValueIterator iter(List) ; iter() ; iter.next())
		s << iter()->text() << endl ;

	return s ;
}
#endif DSCPP_IOSTREAM

/*
** DSValue & dsChangeAssign(DSValue & value, DSValue & data)
**
**	Modify the value object by calling its assign function.
**	This function is executed when the Assign() stream manipulator
**	is called.
*/

DSValue & dsChangeAssign(DSValue & value, DSValue & data, NWSYNTAX_ID)
{
	value.assign(data.syntax(),data.data()) ;

	return value ;
}

/*
** DSManipulator<DSValue &> Value(DSValue & data)
**
**	Create an instance of a manipulator object passing the address of
**	dsChangeValue() function so that the data object can be added to
**	a value object.
*/

DSManipulator<DSValue &> Assign(DSValue & data)
{
	return DSManipulator<DSValue &>(dsChangeAssign,data) ;
}

