/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSVLIST.H - October 1994
**
**	Declaration of the DSVList class used to contain multiple DSValue
**	objects and to hold SYN_CI_LIST and SYN_OCTET_LIST values.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# ifndef dsVLIST_H
# define dsVLIST_H

/*
** Struct DSVListNode
*/

template<class Type> struct _DSCLASSDEC DSVListNode
{
	DSVListNode *	Next ;
	Type *		Data ;

			DSVListNode(Type * data = 0, DSVListNode<Type> * next = 0)
				{ Data = data ; Next = next ; }
		      ~ DSVListNode()
				{ delete Data ; }
} ;

/*
** Struct DSVList
**
**	Used to create a linked list of DSVListNodes.
*/

template<class Type> struct _DSCLASSDEC DSVList
{
	DSVListNode<Type> *	Head ;
	DSVListNode<Type> *	Tail ;
	WORD			Count ;

			DSVList()	{ Head = Tail = 0 ; Count = 0 ; }

		      ~ DSVList()	{ release() ; }

			DSVList  (DSVList<Type> & list)
					{ assign(& list) ; }
	NWDSCCODE	operator=(DSVList<Type> & list)
					{ release() ; return assign(& list) ; }
	Type *		operator[](int) ;
	Type *		create(Type *) ;
	NWDSCCODE	assign(Type *) ;
	NWDSCCODE	assign(DSVList<Type> * list) ;
	NWDSCCODE	release(int = DSCPP_DEF_INDEX) ;
} ;

/*
** Structure DSVListIterator
**
**	Used to iterate through the nodes a DSVList object.
*/

template<class Type> struct _DSCLASSDEC DSVListIterator
{
	DSVListNode<Type> *	Current ;

			DSVListIterator(DSVList<Type> & list) : Current(list.Head) { ; }
			DSVListIterator(DSVListNode<Type> * node) : Current(node) { ; }

	Type *		operator()()	{ return    (Current) ? Current->Data : 0 ; }
	void		next()		{ Current = (Current) ? Current->Next : 0 ; }
} ;

/*
** template<class Type> NWDSCCODE DSVList::assign(DSVList<Type> * list)
**
**	Create a new copy of a DSVList.
*/

template<class Type> _DSTEMPDEC NWDSCCODE DSVList<Type>::assign(DSVList<Type> * list)
{
	Head = Tail = 0 ; Count = 0 ;

	for (DSVListNode<Type> * node = list->Head ; node ; node = node->Next){
		if (node->Data == 0)
			return DSCPP_MEMORY_ERROR ;
		if (assign(create(node->Data)))
			return DSCPP_MEMORY_ERROR ;
		}
	return 0 ;
}

/*
** template<class Type> NWDSCCODE DSVList::assign(Type * data)
**
**	Append the object to the end of the list.
*/

template<class Type> _DSTEMPDEC NWDSCCODE DSVList<Type>::assign(Type * data)
{
DSVListNode<Type> * node = new DSVListNode<Type>(data,0) ;

	if (node == 0) return DSCPP_MEMORY_ERROR ; else Count ++ ;

	if (Head == 0)
		Head = Tail = node ;
	else
		Tail = Tail->Next = node ;
	return 0 ;
}

/*
** template<class Type> Type * DSVList::operator[](int index)
**
**	Return a pointer to the desired value.
*/

template<class Type> _DSTEMPDEC Type * DSVList<Type>::operator[](int index)
{
	if (index < 0 || index >= Count) return 0 ;

	for (DSVListNode<Type> * node = Head ; node ; node = node->Next)
		if (index-- == 0) return node->Data ;

	return 0 ;
}

/*
** NWDSCCODE DSVList::release(int index)
**
**	Delete either a single value or the whole list.
*/

template<class Type> _DSTEMPDEC NWDSCCODE DSVList<Type>::release(int index)
{
	if (index == DSCPP_DEF_INDEX){
		for (Tail = Head ; Head ; Tail = Head){
			Head = Tail->Next ;
			delete Tail ;
			}
		Head  = Tail = 0 ;
		Count = 0 ;
		return 0 ;
		}

	if (index < 0 || index >= Count) return 0 ;

	for (DSVListNode<Type> * node = Head, * prev = 0 ; index-- > 0 ; node = node->Next){
		prev = node ; if (node == 0) return DSCPP_MEMORY_ERROR ;
		}

	if (prev == 0)
		Head = Head->Next ;
	else
		prev->Next = node->Next ;

	if (Tail == node) Tail = prev ;

	Count -- ; delete node ;

	return 0 ;
}

#endif dsVLIST_H

