/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSITERAT.H - October 1994
**
**	Declaration of the DSIteration class.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# ifndef dsITERAT_H
# define dsITERAT_H

# include <nwdstype.h>
# include <nwalias.h>

/*
** Class DSIteration
**
**	Used to pass back results from NDS list, read and search operations.
**	Developers should derive their own classes from DSIteration so that
**	the results can be interpretted. Details of how the list, read and
**	search function use DSIteration are given with the functions.
*/

class _DSCLASSDEC DSIteration
{
protected:

	NWPSTR			ObjectName ;
	NWPSTR			AttrName ;
	void *			Value ;
	void *			Information ;
	NWSYNTAX_ID		Syntax ;
public:
				DSIteration()	{ ; }
virtual			      ~ DSIteration()	{ ; }

virtual	NWDSCCODE		InitLoop()
					{ return 0 ; }
virtual	NWDSCCODE		ExitLoop(NWDSCCODE ccode)
					{ return ccode ; }
virtual	NWDSCCODE		InitObject(NWPSTR object, void * info)
					{ ObjectName = object ; Information = info ; return 0 ; }
virtual	NWDSCCODE		ExitObject(NWPSTR object)
					{ return 0 ; }
virtual	NWDSCCODE		SetAttrName(NWPSTR attrName, NWSYNTAX_ID syntax)
					{ AttrName = attrName ; Syntax = syntax ; return 0 ; }
virtual	NWDSCCODE		SetAttrValue(NWSYNTAX_ID syntax, void * data)
					{ Syntax = syntax ; Value = data ; return 0 ; }
} ;

# endif dsITERAT_H
