/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSFILTER.H - October 1994
**
**	Declaration of the DSFilter class.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# ifndef dsFILTER_H
# define dsFILTER_H

# include "dscontex.h"

/*
** LPDelValueFunc	Type of an optional function that can be supplied to
**			filter operations.
*/

typedef void (*LPDelValueFunc)(NWSYNTAX_ID,void *) ;

/*
** Class DSFilter
**
**	Used to initialise an NWDS buffer for filtering the DSSearch function.
**	The assignment operator and initialisation contructor are declared but
**	not defined, this is to stop the directory buffer being copied and
**	inadvertantly released.
*/

class _DSCLASSDEC DSFilter : public virtual DSContext
{
protected:

	NWDS_BUFFER *		Filter ;
	NWDS_FILTER_CURSOR *	Cursor ;

public:
				DSFilter(WORD size = DEFAULT_MESSAGE_LEN) ;
				DSFilter(DSFilter &) ;
	virtual		      ~ DSFilter() ;
	void			operator=(DSFilter &) ;

	NWDS_BUFFER *		filter()	{ return Filter ; }
	NWDS_FILTER_CURSOR *	cursor()	{ return Cursor ; }


	NWDSCCODE	AllocFilter()
				{ return Status = NWDSAllocFilter(& Cursor) ; }
	NWDSCCODE	AddAttrNameToken(void * data, NWSYNTAX_ID syntax = SYN_CLASS_NAME)
				{ return Status = NWDSAddFilterToken(Cursor,FTOK_ANAME,data,syntax) ; }
	NWDSCCODE	AddAttrValueToken(void * data, NWSYNTAX_ID syntax = SYN_CLASS_NAME)
				{ return Status = NWDSAddFilterToken(Cursor,FTOK_AVAL,data,syntax) ; }
	NWDSCCODE	AddFilterToken(NWDS_TOKEN tok, void * data = 0, NWSYNTAX_ID syntax = 0)
				{ return Status = NWDSAddFilterToken(Cursor,tok,data,syntax) ; }
	NWDSCCODE	DelFilterToken(LPDelValueFunc func = 0)
				{ return Status = NWDSDelFilterToken(Cursor,func) ; }
	NWDSCCODE	FreeFilter(LPDelValueFunc func = 0)
				{ NWDSFreeFilter(Cursor,func) ; return Status = 0 ; }
	NWDSCCODE	InitBuf(NWDS_OPERATION function)
				{ return Status = NWDSInitBuf(dContext,function,Filter) ; }
	NWDSCCODE	PutFilter(LPDelValueFunc func = 0)
				{ return Status = NWDSPutFilter(dContext,Filter,Cursor,func) ; }
} ;

# endif dsFILTER_H
