/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSFILTER.CPP - October 1994
**
**	Initialisation, control and release of directory buffers.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# include "dsdefs.h"
# include "dsfile.h"

# include <fcntl.h>

/*
** NWDSCCODE DSFile::create(NWPSTR object, NWPSTR attr)
**
**	Add the stream attribute to the object. If NWDSModifyObject() returns
**	any of the error codes trapped then the attribute already exists.
*/

NWDSCCODE DSFile::create(NWPSTR object, NWPSTR attr)
{
NWDS_BUFFER NWFAR * buffer ;

	if ((Status = NWDSAllocBuf(DEFAULT_MESSAGE_LEN,& buffer)) != 0)
		return Status ;

	NWDSInitBuf   (Context,DSV_MODIFY_ENTRY,buffer) ;
	NWDSPutChange (Context,buffer,DS_ADD_ATTRIBUTE,attr) ;
	NWDSPutChange (Context,buffer,DS_ADD_VALUE,attr) ;
	NWDSPutAttrVal(Context,buffer,SYN_STREAM,0) ;

	Status = NWDSModifyObject(Context,object,0,0,buffer) ;

	if (Status == ERR_ATTRIBUTE_ALREADY_EXISTS ||
	    Status == ERR_DUPLICATE_VALUE ||
	    Status == ERR_CANT_HAVE_MULTIPLE_VALUES) Status = 0 ;

	NWDSFreeBuf(buffer) ;

	return Status ;
}

/*
** NWDSCCODE DSFile::unlink(NWPSTR object, NWPSTR attr)
**
**	Delete the stream attribute value from the object. For efficiency
**	reasons the attribute value is added again, this is so that the
**	next call to NWDSOpenStream() succeeds without having to create the
**	attribute.
*/

NWDSCCODE DSFile::unlink(NWPSTR object, NWPSTR attr)
{
NWDS_BUFFER NWFAR * buffer ;

	if ((Status = NWDSAllocBuf(DEFAULT_MESSAGE_LEN,& buffer)) != 0)
		return Status ;

	NWDSInitBuf   (Context,DSV_MODIFY_ENTRY,buffer) ;
	NWDSPutChange (Context,buffer,DS_REMOVE_ATTRIBUTE,attr) ;
	NWDSPutChange (Context,buffer,DS_ADD_ATTRIBUTE,attr) ;
	NWDSPutChange (Context,buffer,DS_ADD_VALUE,attr) ;
	NWDSPutAttrVal(Context,buffer,SYN_STREAM,0) ;

	Status = NWDSModifyObject(Context,object,0,0,buffer) ;

	NWDSFreeBuf(buffer) ;

	return Status ;
}

/*
** NWDS_LOGIN_FILE DSFile::open(NWPSTR object, NWPSTR attr, int mode)
**
**	Open the stream attribute for reading or writing. The only modes
**	allowed are READ(1), WRITE(2) and READ/WRITE(3). The standard mode
**	O_RDWR(4) is translated to (3).
*/

NWDS_LOGIN_FILE DSFile::open(NWPSTR object, NWPSTR attr, DWORD mode)
{
	if (Handle != -1) close() ;

	mode &= O_RDONLY|DS_READ_STREAM|DS_WRITE_STREAM ;

	if (mode == O_RDWR) mode = DS_READ_STREAM|DS_WRITE_STREAM ;
	if (mode == DS_WRITE_STREAM) unlink(object,attr) ;

	Status = NWDSOpenStream(Context,object,attr,mode,& Handle) ;

	if (Status == ERR_NO_SUCH_VALUE ||
	    Status == ERR_NO_SUCH_ATTRIBUTE){
		create(object,attr) ;
		Status = NWDSOpenStream(Context,object,attr,mode,& Handle) ;
		}
	if (Status) Handle = -1 ;

	return Handle ;
}

/*
** int DSFile::close()
**
**	Close the file descriptor.
*/

int DSFile::close()
{
	if (Handle != -1){
		::close(Handle) ;
		Handle = -1 ;
		}
	return 0 ;
}


