/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSDUMP.H - October 1994
**
**	Declaration of the DSDumpIteration class.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# ifndef dsDUMP_H
# define dsDUMP_H

# include "dsiterat.h"
# include "iostream.h"

/*
** Class DSDumpIteration
*/

class DSDumpIteration : public DSIteration
{
protected:

public:
				DSDumpIteration()	{ ; }
			      ~ DSDumpIteration()	{ ; }

virtual	NWDSCCODE		InitLoop()
					{ cout << "Initialise loop.\n" ;
					  return DSIteration::InitLoop() ; }
virtual	NWDSCCODE		ExitLoop(NWDSCCODE ccode)
					{ cout << "Terminate loop with code 0x" << hex << ccode << ".\n" ;
					  return DSIteration::ExitLoop(ccode) ; }
virtual	NWDSCCODE		InitObject(NWPSTR object, void * info)
					{ cout << "Init object " << object << ".\n" ;
					  return DSIteration::InitObject(object,info) ; }
virtual	NWDSCCODE		ExitObject(NWPSTR object)
					{ cout << "Exit object " << object << ".\n" ;
					  return DSIteration::ExitObject(object) ; }
virtual	NWDSCCODE		SetAttrName(NWPSTR attrName, NWSYNTAX_ID syntax)
					{ cout << "Set Attr Name " << attrName << ".\n" ;
					  return DSIteration::SetAttrName(attrName,syntax) ; }
virtual	NWDSCCODE		SetAttrValue(NWSYNTAX_ID syntax, void * data)
					{ cout << "Set Attr Value " << syntax << ".\n" ;
					  return DSIteration::SetAttrValue(syntax,data) ; }

} ;

# endif dsDUMP_H
