/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSCONN.CPP - October 1994
**
**	Attaching and locking server connections.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# include "dsdefs.h"
# include "dsconn.h"

/*
** NWDSCCODE DSConn::attach(
**			NWPSTR server,
**			NWPSTR objectName = 0,
**			NWPSTR password   = 0,
**			NWOBJ_TYPE objectType = OT_USER)
**
**	Create an attachment to the specified server. If the server is a
**	bindery server then execute NWLoginToFileServer. If the server is
**	a DS server then authenticate and lock the connection.
*/

NWDSCCODE DSConn::attach(
			NWPSTR		server,
			NWPSTR		objectName,
			NWPSTR		password,
			NWOBJ_TYPE	objectType)
{
	Status	= 0 ;
	Flags	= DSCPP_PRESERVE_CONN ;
	Context	= ERR_CONTEXT_CREATION ;
	ConnHandle = 0 ;

	if (NWGetConnectionHandle((BYTE *)server,0,& ConnHandle,0)){
		Status = NWAttachToFileServer(server,0,& ConnHandle) ;
		Flags  = 0 ;
		if (Status) return Status ;
		}

	Flags |= DSCPP_ATTACHED ;

	if (NWDSAuthenticate(ConnHandle,0,0) == 0){
		Flags |= DSCPP_SYSTEM_DISCONNECT |
			 NWNDS_CONNECTION     |
			 NWNDS_LICENSED       |
			 NWNDS_AUTHENTICATED ;
		LockConnection() ;
		}
	else {
		Status = NWLoginToFileServer(ConnHandle,
				(objectName) ? objectName : "GUEST", objectType,
				(password)   ? password   : "") ;
		}
	return Status ;
}

/*
** NWDSCCODE DSConn::attach(NWCONN_HANDLE conn)
**
**	Create a DSConn object based on the already attached connection
**	handle. The object is flagged as DS_PRESERVE_CONN so that the
**	connection is maintained when the object is deleted.
*/

NWDSCCODE DSConn::attach(NWCONN_HANDLE conn)
{
	Status	= 0 ;
	Flags	= DSCPP_PRESERVE_CONN ;
	Context	= ERR_CONTEXT_CREATION ;

	if (conn == DSCPP_NEAREST_NDS_SERVER){
		Status = NWGetNearestDirectoryService(& ConnHandle) ;
		if (Status) return Status ;
		}
	else
		ConnHandle = conn ;

	if (conn == 0) return Status ;

	Flags |= DSCPP_ATTACHED ;

	if (NWDSAuthenticate(ConnHandle,0,0) == 0){
		Flags |= DSCPP_SYSTEM_DISCONNECT |
			 NWNDS_CONNECTION     |
			 NWNDS_LICENSED       |
			 NWNDS_AUTHENTICATED ;
		LockConnection() ;
		}

	return Status ;
}

/*
** DSConn::DSConn(DSConn & conn)
**
**	Initialise this object from a DSConn object. Label this connection
**	as a preserved connection.
*/

DSConn::DSConn(DSConn & conn)
{
	Status	= 0 ;
	Flags	= conn.Flags | DSCPP_PRESERVE_CONN ;
	Context	= conn.Context ;
	ConnHandle = conn.ConnHandle ;
}

/*
** NWDSCCODE DSConn::detach()
**
**	Release connection unless it has be labelled as PRESERVED_CONN.
*/

NWDSCCODE DSConn::detach()
{
	if ((Flags & (DSCPP_PRESERVE_CONN|DSCPP_ATTACHED)) == DSCPP_ATTACHED){
		if (Flags & NWNDS_CONNECTION){
			UnlockConnection() ;
			NWFreeConnectionSlot(ConnHandle,
				(Flags & DSCPP_SYSTEM_DISCONNECT)
					? SYSTEM_DISCONNECT : TASK_DISCONNECT) ;
			}
		else {
			NWLogoutFromFileServer(ConnHandle) ;
			NWDetachFromFileServer(ConnHandle) ;
			}
		}
	ConnHandle = 0 ;
	Flags	   = 0 ;
	return Status = 0 ;
}

/*
** NWDSCCODE DSConn::AddTrustee(
**			NWPSTR		dirPath,
**			NWPSTR		objectName,
**			NWRIGHTS_MASK	rights,
**			NWDIR_HANDLE	dirHandle = 0)
**
**	Convert the objectName into an objectID for the current connection,
**	and then execute NWAddTrustee() API.
*/

NWDSCCODE DSConn::AddTrustee(
			NWPSTR		dirPath,
			NWPSTR		objectName,
			NWRIGHTS_MASK	rights,
			NWDIR_HANDLE	dirHandle)
{
NWOBJ_ID objectID ;

	MapNameToID(objectName,objectID) ||
	AddTrustee(dirPath,objectID,rights,dirHandle) ;

	return Status ;
}

/*
** NWDSCCODE DSConn::DeleteTrustee(
**			NWPSTR		dirPath,
**			NWPSTR		objectName,
**			NWDIR_HANDLE	dirHandle = 0)
**
**	Convert the objectName into an objectID for the current connection,
**	and then execute NWDeleteTrustee() API.
*/

NWDSCCODE DSConn::DeleteTrustee(
			NWPSTR		dirPath,
			NWPSTR		objectName,
			NWDIR_HANDLE	dirHandle)
{
NWOBJ_ID objectID ;

	MapNameToID(objectName,objectID) ||
	DeleteTrustee(dirPath,objectID,dirHandle) ;

	return Status ;
}


