/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSBUFFER.H - October 1994
**
**	Declaration of the DSBuffer class.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# ifndef dsBUFFER_H
# define dsBUFFER_H

# include "dsinput.h"
# include "dsoutput.h"
# include "dsfilter.h"

# define DSCPP_NO_TIME_FILTER	((TimeStamp_T *) -1L)

/*
** Class DSBuffer
**
**	Used to access the Directory Services. One DSBuffer contains three
**	NWDSBuffers which act as the input, output and filter buffers for
**	the NDS APIs. The assignment operator and initialisation contructor
**	are declared but not defined, this is to stop the directory buffer
**	being copied and inadvertantly released.
*/

class _DSCLASSDEC DSBuffer : public DSInput, public DSOutput, public DSFilter
{
protected:

public:
			DSBuffer(NWPSTR context    = 0,
				 DWORD  flags      = DSCPP_CONTEXT_FLAGS,
				 WORD   inputSize  = DEFAULT_MESSAGE_LEN,
				 WORD   outputSize = DEFAULT_MESSAGE_LEN,
				 WORD   filterSize = DEFAULT_MESSAGE_LEN) ;
			DSBuffer(DSBuffer &) ;
	virtual	      ~ DSBuffer() ;
	void		operator=(DSBuffer &) ;

	virtual	void	InitLoop(DSIteration * iteration) ;
	virtual	void	ExitLoop(DSIteration * iteration) ;

	NWDSCCODE	CloseIteration(NWDS_ITERATION iterHandle, NWDS_OPERATION operation) ;

	NWDSCCODE	ExitFilter() ;

	NWDSCCODE	DoesObjectExist(NWPSTR object) ;

	NWDSCCODE	GetObjectHostServerAddress(NWPSTR object, NWPSTR server, DSIteration * iteration) ;

	NWDSCCODE	GetServerAddresses(NWCONN_HANDLE connHandle, DSIteration * iteration) ;

	NWDSCCODE	InitBuf(NWDS_OPERATION function)
				{ return Status = NWDSInitBuf(dContext,function,Input) ; }
	NWDSCCODE	InitFilter(NWDS_OPERATION function = DSV_SEARCH_FILTER) ;

	NWDSCCODE	InspectEntry(NWPSTR server, NWPSTR object)
				{ return Status = NWDSInspectEntry(dContext,server,object,Output) ; }
	NWDSCCODE	List(NWPSTR object, DSIteration * iteration) ;

	NWDSCCODE	ListByClassAndName(NWPSTR object, NWPSTR className, NWPSTR subordinate, DSIteration * iteration,
				TimeStamp_T * = DSCPP_NO_TIME_FILTER, WORD onlyContainers = 0) ;
	NWDSCCODE	ListContainers(NWPSTR object, DSIteration * iteration) ;

	NWDSCCODE	ListAttrsEffectiveRights(NWPSTR object, NWPSTR subject,
				NWFLAGS allAttrs, DSIteration * iteration) ;
	NWDSCCODE	Read(NWPSTR object, NWDS_TYPE infoType,
				NWFLAGS allAttrs, DSIteration * iteration, TimeStamp_T * = DSCPP_NO_TIME_FILTER) ;
	NWDSCCODE	ReadReferences(NWPSTR server, NWPSTR object, NWDS_TYPE infoType,
				NWFLAGS allAttrs, DSIteration * iteration, DWORD timeStamp) ;
	NWDSCCODE	Search(NWPSTR base, NWFLAGS scope, NWFLAGS searchAliases, NWDS_TYPE infoType,
				NWFLAGS allAttrs, DSIteration * iteration, TimeStamp_T * = DSCPP_NO_TIME_FILTER) ;
} ;

# endif dsBUFFER_H
