/*
** READUSER <name>
**
**	Read the common name, surname and email address of the user.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia.
*/

# define DSCPP_IOSTREAM

# include "dslocale.h"
# include "dsbuffer.h"
# include "dsiterat.h"

# include <string.h>

# define BUFFER_SIZE	32

NWPSTR	UserObjectAttributes[] = { "CN", "Surname", "EMail Address", 0 } ;

class DSUserObject : public DSIteration
{
	char		LoginName[BUFFER_SIZE] ;
	char		Surname  [BUFFER_SIZE] ;
	char		Address  [BUFFER_SIZE] ;
	WORD		Index ;
public:
			DSUserObject()
				{ LoginName[0] = Surname[0] = Address[0] = 0 ; }
	NWDSCCODE	InitLoop()
				{ Index = 0xffff ; return 0 ; }
	NWDSCCODE	SetAttrName(NWPSTR attrName, NWSYNTAX_ID syntax) ;

	NWDSCCODE	SetAttrValue(NWSYNTAX_ID syntax, void * data) ;

friend	ostream &	operator<<(ostream & s, DSUserObject & u) ;
} ;

NWDSCCODE DSUserObject::SetAttrName(NWPSTR attrName, NWSYNTAX_ID)
{
	for (Index = 0 ; UserObjectAttributes[Index] ; Index++)
		if (stricmp(UserObjectAttributes[Index],attrName) == 0)	return 0 ;

	return 0 ;
}

NWDSCCODE DSUserObject::SetAttrValue(NWSYNTAX_ID, void * data)
{
	switch (Index) {
	    case 0:
		strncpy(LoginName,(NWPSTR) data,BUFFER_SIZE) ; break ;
	    case 1:
		strncpy(Surname,  (NWPSTR) data,BUFFER_SIZE) ; break ;
	    case 2:
		strncpy(Address,  (NWPSTR) data,BUFFER_SIZE) ; break ;
	    }
	return 0 ;
}

ostream & operator<<(ostream & s, DSUserObject & user)
{
	return s << "Login\t"   << user.LoginName << "\n"
		 << "Surname\t" << user.Surname   << "\n"
		 << "Address\t" << user.Address   << "\n" ;
}

int main(int argc, char * argv[])
{
DSLocale	dsLocale ;
DSBuffer	dsBuffer ;
DSUserObject	dsUserObject ;

	if (argc != 2){
		cout << "Usage: READUSER relative-distinguished-name\n" ; return 0 ;
		}
	if (dsLocale.status() || dsBuffer.status()){
		cout << "READUSER: Cannot initialise Unicode\n" ; return 0 ;
		}

	dsBuffer.InitBuf(DSV_READ) ;
	dsBuffer.PutAttrName(UserObjectAttributes) ;

	if (dsBuffer.Read(argv[1],TRUE,FALSE,& dsUserObject) == 0)
		cout << dsUserObject ;
	else
		cout << "Cannot read user \"" << argv[1] << "\"\n" ;
	return 0 ;
}