/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSVALUE.H - October 1994
**
**	Declaration of the DSV... classes used to describe NDS syntaxes.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# ifndef dsVALUE_H
# define dsVALUE_H

# include "dsdefs.h"

# define DSCPP_WRONG_TYPE		((int) 0x8700)
# define DSCPP_UNDEFINED		((int) 0x8701)
# define DSCPP_MEMORY_ERROR		((int) 0x8702)

# define DSCPP_DEF_INDEX		(-1)

/*
** DSValueType		The 27 syntaxes used by the NDS are implemented using
**			the DSV types listed in the enumeration.
*/

enum DSValueType {
	DSCPP_UNKNOWN		= 0,
	DSCPP_STRING		= 1,
	DSCPP_STRING_LIST	= 2,
	DSCPP_BOOLEAN		= 3,
	DSCPP_INTEGER		= 4,
	DSCPP_OCTET_STRING	= 5,
	DSCPP_FAX_NUMBER	= 6,
	DSCPP_NET_ADDRESS	= 7,
	DSCPP_OCTET_LIST	= 8,
	DSCPP_EMAIL_ADDRESS	= 9,
	DSCPP_PATH		= 10,
	DSCPP_REPLICA		= 11,
	DSCPP_OBJECT_ACL	= 12,
	DSCPP_POSTAL_ADDRESS	= 13,
	DSCPP_TIMESTAMP		= 14,
	DSCPP_STREAM		= 15,
	DSCPP_BACK_LINK		= 16,
	DSCPP_TIME		=  4,
	DSCPP_TYPED_NAME	= 18,
	DSCPP_HOLD		= 19,
	DSCPP_INTERVAL		= 20,
	DSCPP_MULTI_VALUE	= 21,
	} ;

/*
** dsValueTypeArray[]		Used to cross-reference between NDS syntax
**				ids and the DSV classes that implement them.
*/

extern DSValueType dsValueTypeArray[] ;

/*
** Struct DSValue
**
**	Used as a base class for the DSV types. Note that this class uses
**	virtual functions and has a non static member, hence a pointer to
**	a DSV class does NOT point to the start of a NDS syntax. To use this
**	class in NDS buffer functions, use the member function data().
*/

struct _DSCLASSDEC DSValue
{
	NWSYNTAX_ID	Syntax ;
	NWSYNTAX_ID	syntax()				{ return Syntax ; }

static	char		Buffer[] ;
static	NWPSTR		strnew(const NWPSTR string) ;
static	DSValue *	create(NWSYNTAX_ID, void *) ;
static	NWDSCCODE	checkTypeAndSyntax(DSValue *, WORD) ;

virtual	NWDSCCODE	assign (NWSYNTAX_ID, void *)		{ return 0 ; }
virtual	NWDSCCODE	release(int = DSCPP_DEF_INDEX)		{ Syntax = 0 ; return 0 ; }
virtual	NWDSCCODE	compare(DSValue * v)			{ return 0 ; }

			DSValue(NWSYNTAX_ID s = 0, void * = 0)	{ Syntax = s ; }
virtual		      ~	DSValue()				{ ; }

virtual	NWDSCCODE	operator==(DSValue & v)			{ return compare(&v) ; }
virtual	DSValueType	type()					{ return DSCPP_UNKNOWN ; }
virtual	NWPSTR		text(int = DSCPP_DEF_INDEX)		{ return "" ; }
virtual	void *		data()					{ return 0 ; }

#ifdef DSCPP_IOSTREAM
virtual	ostream &	stream(ostream & s)			{ return s << text() ; }
#endif DSCPP_IOSTREAM
} ;

#ifdef DSCPP_IOSTREAM
inline	ostream & operator<<(ostream & s, DSValue & v)		{ return v.stream(s) ; }
#endif DSCPP_IOSTREAM

/*
** Class DSManipulator
**
**	Used as a stream manipulator to set the value of DSV objects.
*/

template<class T> class _DSCLASSDEC DSManipulator {
	DSValue &	(*Func)(DSValue &, T, NWSYNTAX_ID) ;
	T		Arg ;
	NWSYNTAX_ID	Syntax ;
public:
			DSManipulator(DSValue & (*func)(DSValue &, T, NWSYNTAX_ID), T arg, NWSYNTAX_ID syn = 0) :
				Func(func), Arg(arg), Syntax(syn) { }

friend DSValue &	operator<<(DSValue & value, DSManipulator<T> & manipulator)
				{ (*manipulator.Func)(value,manipulator.Arg,manipulator.Syntax) ; return value ; }
} ;

DSValue & dsChangeValue(DSValue & value, void * data, NWSYNTAX_ID syntax) ;

DSManipulator<NWSYNTAX_ID> _DSFUNCDEC	Syntax(NWSYNTAX_ID) ;
DSManipulator<void *>	   _DSFUNCDEC	Integer(long) ;
DSManipulator<void *>	   _DSFUNCDEC	Counter(DWORD) ;
DSManipulator<void *>	   _DSFUNCDEC	Time(time_t) ;
DSManipulator<void *>	   _DSFUNCDEC	Boolean(int) ;
DSManipulator<NWPSTR>	   _DSFUNCDEC	String(NWPSTR) ;
DSManipulator<DSValue &>   _DSFUNCDEC	Assign(DSValue &) ;
DSManipulator<NWPSTR>	   _DSFUNCDEC	Address(NWPSTR) ;
DSManipulator<DWORD>	   _DSFUNCDEC	Type(DWORD) ;

#endif dsVALUE_H

