/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSPARTIT.CPP - October 1994
**
**	Access to NDS Partition APIs.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# include "dsdefs.h"
# include "dspartit.h"
# include "dsiterat.h"

/*
** NWDSCCODE DSPartition::AddPartition(
**			NWPSTR	server,
**			NWPSTR	root,
**			NWFLAGS	more = 0)
**
**	Creates a partition root object, using the attributes given in
**	the input buffer. The iteration handle is kept as a static variable
**	and is reset when there are no more iterations (ie more is zero).
*/

NWDSCCODE DSPartition::AddPartition(NWPSTR server, NWPSTR root, NWFLAGS more)
{
static NWDS_ITERATION iterHandle = -1 ;

	Status = NWDSAddPartition(dContext,server,root,& iterHandle,more,Input) ;

	if (more == 0) iterHandle = -1 ;

	return Status ;
}

/*
** NWDSCCODE DSPartition::ListPartitions(
**				NWPSTR		server,
**				DSIteration *	iteration)
**
**	List the relicas of partitions stored on the server.
**	NWDSListPartition iteration is managed by using a DSIteration object.
**	Developers should derive their own classes from DSIteration and
**	override the class's functions to receive the results.
**
**	DSIteration Protocol:
**		InitLoop()
**		InitObject(ServerName,0)
**		for each partition
**			SetAttrName(PartitionName,ReplicaType)
**		ExitObject(ServerName)
**		ExitLoop(Status)
*/

NWDSCCODE DSPartition::ListPartitions(NWPSTR server, DSIteration * iteration)
{
NWDS_ITERATION	iterHandle  = -1 ;
NWCOUNT		itemCount   =  0 ;
NWREPLICA_TYPE	replicaType =  0 ;

	InitLoop(iteration) ;

	do {
		Status = NWDSListPartitions(
				dContext, 	// Directory context
			      & iterHandle,   	// Iteration handle
				server,	      	// Base of listing
				Output) ;     	// Object return buffer

		if (Status == 0 && GetServerName(ObjectName,itemCount) == 0)
			InitObject(iteration,ObjectName,0) ;

		for (short i = 0 ; Status == 0 && i < itemCount ; i++){
			if (GetPartitionInfo(ObjectAttr,replicaType) == 0)
				SetAttrName(iteration,ObjectAttr,replicaType) ;
			}
	} while (iterHandle != -1 && Status == 0) ;

	ExitLoop(iteration) ;

	if (Status > 0) CloseIteration(iterHandle,DSV_LIST) ;

	return Status ;
}


