/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSAUDIT.CPP - October 1994
**
**	Volume and container auditing.
**
**	The volume and container auditing APIs have been combined into a
**	single API set. The type of auditing being performed depends on
**	whether LoginAsVolumeAuditor or LoginAsContainerAuditor is executed.
**	The member functions of DSAudit determine the type of auditing being
**	performed and execute the appropriate auditing API.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# include "dsdefs.h"
# include "dsaudit.h"

DSAudit::~DSAudit()
{
	if (attached() && ObjectID) LogoutAsAuditor() ;
}

NWDSCCODE DSAudit::AddAuditProperty(DWORD objectID)
{
	return Status = (AuditContainer)
		? NWDSChangeObjectAuditProperty(ConnHandle,ObjectID,AuditKey,ObjectID,1)
		: NWAddAuditProperty           (ConnHandle,ObjectID,AuditKey,objectID) ;
}

NWDSCCODE DSAudit::ChangeAuditorPassword(BYTE * password, BYTE level)
{
	return Status = (AuditContainer)
		? NWDSChangeAuditorPassword(ConnHandle,ObjectID,AuditKey,password,level)
		: NWChangeAuditorPassword  (ConnHandle,ObjectID,AuditKey,password,level) ;
}

NWDSCCODE DSAudit::ChangeAuditProperty(DWORD objectID, BYTE flag)
{
	return Status = (AuditContainer)
		? NWDSChangeObjectAuditProperty(ConnHandle,ObjectID,AuditKey,objectID,flag)
		: flag
		  ? NWAddAuditProperty   (ConnHandle,ObjectID,AuditKey,objectID)
		  : NWRemoveAuditProperty(ConnHandle,ObjectID,AuditKey,objectID) ;
}

NWDSCCODE DSAudit::CheckAuditAccess()
{
	return (AuditContainer)
		? NWDSCheckAuditAccess(ConnHandle,ObjectID)
		: NWCheckAuditAccess  (ConnHandle,ObjectID) ;
}

NWDSCCODE DSAudit::CheckAuditLevelTwoAccess()
{
	return Status = (AuditContainer)
		? NWDSCheckAuditLevelTwoAccess(ConnHandle,ObjectID,AuditKey)
		: NWCheckAuditLevelTwoAccess  (ConnHandle,ObjectID,AuditKey) ;
}

NWDSCCODE DSAudit::CloseOldAuditingFile()
{
	return Status = (AuditContainer)
		? NWDSCloseOldAuditingFile(ConnHandle,ObjectID,AuditKey)
		: NWCloseOldAuditingFile  (ConnHandle,ObjectID,AuditKey) ;
}

NWDSCCODE DSAudit::DeleteOldAuditingFile()
{
	return Status = (AuditContainer)
		? NWDSDeleteOldAuditingFile(ConnHandle,ObjectID,AuditKey)
		: NWDeleteOldAuditingFile  (ConnHandle,ObjectID,AuditKey) ;
}

NWDSCCODE DSAudit::DisableAuditingOnObject()
{
	return Status = (AuditContainer)
		? NWDSDisableAuditingOnContainer(ConnHandle,ObjectID,AuditKey)
		: NWDisableAuditingOnVolume     (ConnHandle,ObjectID,AuditKey) ;
}

NWDSCCODE DSAudit::EnableAuditingOnObject()
{
	return Status = (AuditContainer)
		? NWDSEnableAuditingOnContainer(ConnHandle,ObjectID,AuditKey)
		: NWEnableAuditingOnVolume     (ConnHandle,ObjectID,AuditKey) ;
}

NWDSCCODE DSAudit::GetAuditingFlags(NWFLAGS & flags)
{
	return Status = (AuditContainer)
		? NWDSGetAuditingFlags(ConnHandle,ObjectID,AuditKey,& flags)
		: NWGetAuditingFlags  (ConnHandle,ObjectID,AuditKey,& flags) ;
}

NWDSCCODE DSAudit::GetObjectAuditStats(void * buffer, WORD size)
{
	if (AuditContainer){
		if (size == 0) size = sizeof(NWContainerAuditStatus) ;
		return Status = NWDSGetContainerAuditStats(ConnHandle,ObjectID,
					(NWContainerAuditStatus *)buffer,size) ;
		}
	else {
		if (size == 0) size = sizeof(NWVolumeAuditStatus) ;
		return Status = NWGetVolumeAuditStats(ConnHandle,ObjectID,
					(NWVolumeAuditStatus*)buffer,size) ;
		}
}

NWDSCCODE DSAudit::InitAuditFileRead(int fileCode)
{
	FileCode = fileCode ;
	EofFlag  = 0 ;
	return Status = NWInitAuditFileRead(ConnHandle,ObjectID,fileCode,AuditContainer) ;
}

NWDSCCODE DSAudit::InitAuditLevelTwoPassword(BYTE * password)
{
	return Status = NWInitAuditLevelTwoPassword(AuditKey,password) ;
}

NWDSCCODE DSAudit::IsObjectBeingAudited(DWORD objectID)
{
	return Status = (AuditContainer)
		? NWDSIsObjectBeingAudited(ConnHandle,ObjectID,AuditKey,objectID)
		: NWIsUserBeingAudited    (ConnHandle,ObjectID,AuditKey,objectID) ;
}

NWDSCCODE DSAudit::LoginAsContainerAuditor(DWORD container, BYTE * password)
{
	if (! attached()) return 0x8801 ;

	if (ObjectID) LogoutAsAuditor() ;

	Status = NWDSLoginAsContainerAuditor(ConnHandle,container,AuditKey,password) ;

	if (Status == (NWDSCCODE)0x8997){
		NWDSEnableAuditingOnContainer(ConnHandle,container,AuditKey) ;
		Status = NWDSLoginAsContainerAuditor(ConnHandle,container,AuditKey,(BYTE*)password) ;
		}
	if (Status == 0){
		ObjectID = container ;
		AuditContainer = 1 ;
		FileCode = 0xffff ;
		}
	return Status ;
}

NWDSCCODE DSAudit::LoginAsVolumeAuditor(DWORD volume, BYTE * password)
{
	if (! attached()) return 0x8801 ;

	if (ObjectID) LogoutAsAuditor() ;

	Status = NWLoginAsVolumeAuditor(ConnHandle,volume,AuditKey,password) ;

	if (Status == (NWDSCCODE) 0x8997){
		NWEnableAuditingOnVolume(ConnHandle,volume,AuditKey) ;
		Status = NWLoginAsVolumeAuditor(ConnHandle,volume,AuditKey,password) ;
		}
	if (Status == 0){
		ObjectID = volume ;
		AuditContainer = 0 ;
		FileCode = 0xffff ;
		}
	return Status ;
}

NWDSCCODE DSAudit::LogoutAsAuditor()
{
	if (! attached()) return 0x8801 ;

	Status = (AuditContainer)
		? NWDSLogoutAsContainerAuditor(ConnHandle,ObjectID,AuditKey)
		: NWLogoutAsVolumeAuditor     (ConnHandle,ObjectID,AuditKey) ;

	ObjectID = 0 ;

	return Status ;
}

NWDSCCODE DSAudit::ReadAuditConfigHeader(void * buffer, WORD size)
{
	if (AuditContainer){
		if (size == 0) size = sizeof(NWDSContainerConfigHdr) ;
		return Status = NWDSReadAuditConfigHeader(ConnHandle,ObjectID,AuditKey,
					(NWDSContainerConfigHdr *)buffer,size) ;
		}
	else {
		if (size == 0) size = sizeof(NWConfigHeader) ;
		return Status = NWReadAuditConfigHeader  (ConnHandle,ObjectID,AuditKey,
					(NWConfigHeader *)buffer,size) ;
		}
}

NWDSCCODE DSAudit::ReadAuditingBitMap(NWAuditBitMap * buffer, WORD size)
{
	return Status = (AuditContainer)
		? 0x8811
		: NWReadAuditingBitMap(ConnHandle,ObjectID,AuditKey,buffer,size) ;
}

NWDSCCODE DSAudit::ReadAuditingFileRecord(void * buffer, WORD bufferSize, WORD & returnSize)
{
	if (EofFlag) return 0xffff ;

	Status = NWReadAuditingFileRecord(ObjectID,FileCode,buffer,& returnSize,bufferSize,& EofFlag) ;

	return (returnSize == 0) ? 0xffff : Status ;
}

NWDSCCODE DSAudit::RemoveAuditProperty(DWORD objectID)
{
	return Status = (AuditContainer)
		? NWDSChangeObjectAuditProperty(ConnHandle,ObjectID,AuditKey,objectID,0)
		: NWRemoveAuditProperty        (ConnHandle,ObjectID,AuditKey,objectID) ;
}

NWDSCCODE DSAudit::ResetAuditHistoryFile()
{
	return Status = (AuditContainer)
		? 0x8811
		: NWResetAuditHistoryFile(ConnHandle,ObjectID,AuditKey) ;
}

NWDSCCODE DSAudit::ResetAuditingFile()
{
	return Status = (AuditContainer)
		? NWDSResetAuditingFile(ConnHandle,ObjectID,AuditKey)
		: NWResetAuditingFile  (ConnHandle,ObjectID,AuditKey) ;
}

NWDSCCODE DSAudit::WriteAuditConfigHeader(void * buffer)
{
	return Status = (AuditContainer)
		? NWDSWriteAuditConfigHeader(ConnHandle,ObjectID,AuditKey,
				(NWDSContainerConfigHdr *) buffer)
		: NWWriteAuditConfigHeader  (ConnHandle,ObjectID,AuditKey,
				(NWConfigHeader *) buffer) ;
}

NWDSCCODE DSAudit::WriteAuditingBitMap(NWEventBitMap * buffer)
{
	return Status = (AuditContainer)
		? 0x8811
		: NWWriteAuditingBitMap(ConnHandle,ObjectID,AuditKey,buffer) ;
}

# ifdef DSCPP_WINDOWS
NWCCODE NWAPI NWDSIsObjectBeingAudited(NWCONN_HANDLE,LONG,BYTE NWFAR *,LONG)
{
	return 0x8811 ;
}

NWCCODE NWAPI NWDSChangeObjectAuditProperty(NWCONN_HANDLE,LONG,BYTE NWFAR *,LONG,BYTE)
{
	return 0x8811 ;
}
# endif
