/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSVADDR.H - February 1995
**
**	Declaration of the DSVString and DSVStringList classes.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# ifndef dsVADDR_H
# define dsVADDR_H

# include "dsvalue.h"

/*
** Structure DSVPostalAddress
**
**	Used to hold a postal address
*/

struct _DSCLASSDEC DSVPostalAddress : public DSValue
{
	NWPSTR		Address[NUM_POSTAL_ADDRESS_ELEMENTS] ;

	NWDSCCODE	assign (NWSYNTAX_ID, void *) ;
	NWDSCCODE	assign (DSVPostalAddress *) ;
	NWDSCCODE	release(int = DSCPP_DEF_INDEX) ;
	NWDSCCODE	compare(DSValue *) ;

			DSVPostalAddress() ;
			DSVPostalAddress(NWSYNTAX_ID s,void *v)	{ assign(s,v) ; }
			DSVPostalAddress(DSVPostalAddress & v)	{ assign(& v) ; }
		      ~	DSVPostalAddress()			{ release() ; }
	void		operator=(DSVPostalAddress & v)		{ assign(& v) ; }

	void *		data()					{ return & Address ; }
	DSValueType	type()					{ return DSCPP_POSTAL_ADDRESS ; }
	NWPSTR		text(int = DSCPP_DEF_INDEX) ;
} ;

/*
** Structure DSVEmailAddress
**
**	Used to hold an email address
*/

struct _DSCLASSDEC DSVEmailAddress : public DSValue
{
	DWORD		Type ;
	NWPSTR		Address ;

	NWDSCCODE	assign (NWSYNTAX_ID, void *) ;
	NWDSCCODE	assign (DSVEmailAddress *) ;
	NWDSCCODE	release(int = DSCPP_DEF_INDEX) ;
	NWDSCCODE	compare(DSValue *) ;

			DSVEmailAddress()			{ Address = 0 ; Type = 0 ; }
			DSVEmailAddress(NWSYNTAX_ID s,void *v)	{ assign(s,v) ; }
			DSVEmailAddress(DSVEmailAddress & v)	{ assign(& v) ; }
		      ~	DSVEmailAddress()			{ release() ; }
	void		operator=(DSVEmailAddress & v)		{ assign(& v) ; }

	void *		data()					{ return & Type ; }
	DSValueType	type()					{ return DSCPP_EMAIL_ADDRESS ; }
	NWPSTR		text(int = DSCPP_DEF_INDEX) ;
} ;

/*
** Structure DSVNetAddress
**
**	Used to hold a network address
*/

struct _DSCLASSDEC DSVNetAddress : public DSValue
{
	DWORD		Type ;
	DWORD		Length ;
	BYTE *		Address ;

	NWDSCCODE	assign (NWSYNTAX_ID, void *) ;
	NWDSCCODE	assign (DSVNetAddress *) ;
	NWDSCCODE	release(int = DSCPP_DEF_INDEX) ;
	NWDSCCODE	compare(DSValue *) ;

			DSVNetAddress()				{ Address = 0 ; Type = Length = 0 ; }
			DSVNetAddress(NWSYNTAX_ID s, void * v)	{ assign(s,v) ; }
			DSVNetAddress(DSVNetAddress & v)	{ assign(& v) ; }
		      ~	DSVNetAddress()				{ release() ; }
	void		operator=(DSVNetAddress & v)		{ assign(& v) ; }

	void *		data()					{ return & Type ; }
	DSValueType	type()					{ return DSCPP_NET_ADDRESS ; }
	NWPSTR		text(int = DSCPP_DEF_INDEX) ;
        int		parseAddress(NWPSTR address) ;
} ;

#endif dsVADDR_H

