/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSSCHEME.H - October 1994
**
**	Declaration of the DSSchema class.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# ifndef dsSCHEME_H
# define dsSCHEME_H

# include "dsbuffer.h"

/*
** Class DSSchema
**
**	Used to access and modify the Directory Service Schema. The assignment
**	operator and initialisation contructor are declared but not defined,
**	this is to stop the directory buffer being copied and inadvertantly
**	released.
*/

class _DSCLASSDEC DSSchema : public DSBuffer
{
protected:

public:
			DSSchema(NWPSTR context, WORD flags = 0,
				 WORD inputSize  = DEFAULT_MESSAGE_LEN,
				 WORD outputSize = DEFAULT_MESSAGE_LEN,
				 WORD filterSize = DEFAULT_MESSAGE_LEN)
				 : DSBuffer(context,flags,inputSize,outputSize,filterSize) { ; }
			DSSchema(DSSchema &) ;
	virtual	      ~ DSSchema() { ; }
	void		operator=(DSSchema &) ;

	NWDSCCODE 	DefineAttr(NWPSTR attrName, NWATTR_INFO * attrInfo)
				{ return Status = NWDSDefineAttr(dContext,attrName,attrInfo) ; }
	NWDSCCODE 	DefineClass(NWPSTR className, NWCLASS_INFO * classInfo)
				{ return Status = NWDSDefineClass(dContext,className,classInfo,Input) ; }
	NWDSCCODE 	DefineClass(NWPSTR classDetails[], NWCLASS_INFO * classInfo) ;

	NWDSCCODE 	DefineClass(NWPSTR classDetails[], NWDS_FLAGS classFlags = DS_EFFECTIVE_CLASS) ;

	NWDSCCODE 	GetAttrDef(NWPSTR attrName, NWATTR_INFO * attrDef)
				{ return Status = NWDSGetAttrDef(dContext,Output,attrName,attrDef) ; }
	NWDSCCODE 	GetClassDefCount(NWCOUNT & count)
				{ return Status = NWDSGetClassDefCount(dContext,Output,& count) ; }
	NWDSCCODE 	GetClassDef(NWPSTR className, NWCLASS_INFO * classDef)
				{ return Status = NWDSGetClassDef(dContext,Output,className,classDef) ; }
	NWDSCCODE 	GetSyntaxCount(NWCOUNT & count)
				{ return Status = NWDSGetSyntaxCount(dContext,Output,& count) ; }
	NWDSCCODE 	GetSyntaxDef(NWPSTR syntaxName, NWSYNTAX_INFO * syntaxDef)
				{ return Status = NWDSGetSyntaxDef(dContext,Output,syntaxName,syntaxDef) ; }
	NWDSCCODE 	GetSyntaxID(NWPSTR attrName, NWSYNTAX_ID & syntaxID)
				{ return Status = NWDSGetSyntaxID(dContext,attrName,& syntaxID) ; }
	NWDSCCODE 	ListContainableClasses(NWPSTR parent, DSIteration * iteration) ;

	NWDSCCODE 	ModifyClassDef(NWPSTR className)
				{ return Status = NWDSModifyClassDef(dContext,className,Input) ; }
	NWDSCCODE 	ReadAttrDef(NWDS_TYPE infoType, NWFLAGS allAttrs, DSIteration * iteration) ;

	NWDSCCODE 	ReadClassDef(NWDS_TYPE infoType, NWFLAGS allClasses, DSIteration * iteration) ;

	NWDSCCODE	ReadSyntaxDef(NWSYNTAX_ID syntaxID, NWSYNTAX_INFO * info)
				{ return Status = NWDSReadSyntaxDef(dContext,syntaxID,info) ; }
	NWDSCCODE 	ReadSyntaxes(NWDS_TYPE infoType, NWFLAGS allSyntaxes, DSIteration * iteration) ;

	NWDSCCODE 	RemoveAttrDef(NWPSTR attrName)
				{ return Status = NWDSRemoveAttrDef(dContext,attrName) ; }
	NWDSCCODE 	RemoveClassDef(NWPSTR className)
				{ return Status = NWDSRemoveClassDef(dContext,className) ; }
	NWDSCCODE 	ReplaceAttrNameAbbrev(NWPSTR shortName, NWPSTR longName)
				{ return Status = NWDSReplaceAttrNameAbbrev(dContext,shortName,longName) ; }

virtual	NWDSCCODE	ListClassItems(DSIteration * iteration, NWSYNTAX_ID type = 0) ;
virtual	NWDSCCODE	ListAttrDef   (DSIteration * iteration) ;
virtual	NWDSCCODE	ListClassDef  (DSIteration * iteration, NWDS_TYPE infoType) ;
virtual	NWDSCCODE	ListSyntaxes  (DSIteration * iteration) ;
} ;

# endif dsSCHEME_H
