/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSOUTPUT.CPP - October 1994
**
**	Initialisation, control and release of directory buffers.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# include "dsdefs.h"
# include "dsoutput.h"
# include "dsiterat.h"
# include <string.h>

/*
** DSOutput::objectValue[]	Static member arrays used to hold temporary
** DSOutput::objectAttr[]	results from NWDSGet...() operations.
** DSOutput::objectName[]
*/

char	DSOutput::ObjectValue[DEFAULT_MESSAGE_LEN] ;
char	DSOutput::ObjectAttr [MAX_SCHEMA_NAME_BYTES] ;
char	DSOutput::ObjectName [MAX_DN_BYTES] ;
char	DSOutput::CurrentAttr[MAX_SCHEMA_NAME_BYTES] ;
char	DSOutput::CurrentName[MAX_DN_BYTES] ;

/*
** DSOutput::DSOutput(WORD size = DEFAULT_MESSAGE_LEN)
**
**	Allocate memory for the output buffer.
*/

DSOutput::DSOutput(WORD size)
{
	Output = 0 ; if (size == 0) return ;

	if ((Status = NWDSAllocBuf(size,& Output)) != 0) Output = 0 ;
}

/*
** DSOutput::~DSOutput()
**
**	Release memory used by the input buffer.
*/

DSOutput::~DSOutput()
{
	if (Output) NWDSFreeBuf(Output) ;
}

/*
** DSOutput::InitLoop(DSIteration *)
**
**	Clear the current name buffers.
*/

void DSOutput::InitLoop(DSIteration *)
{
	CurrentName[0] = CurrentAttr[0] = 0 ;
}

/*
** DSOutput::ExitLoop(DSIteration * iteration)
**
**	Flush the current name buffers.
*/

void DSOutput::ExitLoop(DSIteration * iteration)
{
	if (CurrentName[0])
		iteration->ExitObject(CurrentName) ;
}

/*
** NWDSCCODE DSOutput::InitObject(
**			DSIteration *	iteration,
**			NWPSTR		objectName,
**			void *		info)
**
**	Execute the iteration class's InitObject function if this is a
**	new object.
*/

NWDSCCODE DSOutput::InitObject(DSIteration * iteration, NWPSTR objectName, void * info)
{
	if (stricmp(CurrentName,objectName)){
		if (Status == 0 && CurrentName[0]){
			Status = iteration->ExitObject(CurrentName) ;
			CurrentName[0] = 0 ;
			}
		if (Status == 0){
			strcpy(CurrentName,objectName) ;
			Status = iteration->InitObject(objectName,info) ;
			}
		}
	return Status ;
}

/*
** NWDSCCODE DSOutput::SetAttrName(
**			DSIteration *	iteration,
**			NWPSTR		objectAttr,
**			NWSYNTAX_ID	syntax)
**
**	Execute the iteration class's SetAttrName function if this is a
**	new attribute.
*/

NWDSCCODE DSOutput::SetAttrName(DSIteration * iteration, NWPSTR objectAttr, NWSYNTAX_ID syntax)
{
	if (stricmp(CurrentAttr,objectAttr)){
		strcpy(CurrentAttr,objectAttr) ;
		Status = iteration->SetAttrName(objectAttr,syntax) ;
		}
	return Status ;
}

/*
** NWDSCCODE DSOutput::ListValue(
**			DSIteration *	iteration,
**			NWCOUNT		valueCount,
**			NWSYNTAX_ID	syntax)
**
**	Unload attribute value information from the output buffer.
*/

NWDSCCODE DSOutput::ListValues(DSIteration * iteration, NWCOUNT valueCount, NWSYNTAX_ID syntax)
{
	if (valueCount == DSCPP_NO_COUNT && GetAttrName(ObjectAttr,valueCount,syntax) == 0)
		SetAttrName(iteration,ObjectAttr,syntax) ;

	for (int i = 0 ; Status == 0 && i < valueCount ; i++){
		if (GetAttrVal(syntax,ObjectValue) == 0)
			Status = iteration->SetAttrValue(syntax,ObjectValue) ;
		}
	return Status ;
}

/*
** NWDSCCODE DSOutput::ListAttributes(DSIteration * iteration)
**
**	Unload attribute information from the output buffer.
*/

NWDSCCODE DSOutput::ListAttributes(DSIteration * iteration, NWCOUNT attrCount)
{
NWCOUNT		valueCount ;
NWSYNTAX_ID	syntax ;

	if (attrCount == DSCPP_NO_COUNT) GetAttrCount(attrCount) ;

	for (int i = 0 ; Status == 0 && i < attrCount ; i++){
		if (GetAttrName(ObjectAttr,valueCount,syntax) == 0 &&
		    SetAttrName(iteration,ObjectAttr,syntax)  == 0)
			ListValues(iteration,valueCount,syntax) ;
		}
	return Status ;
}

/*
** NWDSCCODE DSOutput::ListObjects(DSIteration * iteration)
**
**	Unload all objects, object attributes and values from the buffer. The
**	buffer has been filled by a call to NWDSSearch.
*/

NWDSCCODE DSOutput::ListObjects(DSIteration * iteration)
{
NWCOUNT		objCount ;
NWCOUNT		attrCount ;
NWOBJECT_INFO	info ;

	GetObjectCount(objCount) ;

	for (short i = 0 ; Status == 0 && i < objCount ; i++){
		if (GetObjectName(ObjectName,attrCount,& info) == 0 &&
		    InitObject   (iteration,ObjectName,& info) == 0 && attrCount > 0)
			ListAttributes(iteration,attrCount) ;
		}
	return Status ;
}


