/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSOBJECT.H - October 1994
**
**	Declaration of the DSObject and DSReadObject classes.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

#ifndef dsOBJECT_H
#define dsOBJECT_H

#include "dsbuffer.h"
#include "dsvalue.h"
#include "dsiterat.h"

class _DSCLASSDEC DSObject ;
class _DSCLASSDEC DSReadObject ;

/*
** Structure DSForAllData	Used to transfer iteration data between
**				DSObject::ForAll() and the iteration function.
*/

struct _DSCLASSDEC DSForAllData
{
	DSObject *	object ;
	WORD		attrIndex ;
	WORD		valueIndex ;
	void *		data1 ;
	void *		data2 ;
} ;

/*
** typedef DSForAllFunc		Typedef of function executed by
**				DSObject::ForAll().
*/

typedef NWDSCCODE (*DSForAllFunc)(DSValue *, DSForAllData *) ;

/*
** Class DSObject
**
**	DSObject provides a generic base class for storing NDS objects. Classes
**	derived from DSObject need to override the functions FindAttribute(),
**	AttributeNames() and AttributeCount() so that the ReadObject() and
**	WriteObject() can locate the class' attributes.
*/

class _DSCLASSDEC DSObject
{
friend class DSReadObject ;

static	NWDSCCODE	ReleaseAll(DSValue *, DSForAllData *) ;
static	NWDSCCODE	DisplayAll(DSValue *, DSForAllData *) ;
static	NWDSCCODE	WriteAll  (DSValue *, DSForAllData *) ;

static	NWDSCCODE	WriteNewValue   (DSBuffer *, NWPSTR, DSValue *) ;
static	NWDSCCODE	WriteSingleValue(DSBuffer *, NWPSTR, DSValue *, DSValue *) ;
static	NWDSCCODE	WriteMultiValue (DSBuffer *, NWPSTR, DSValue *, DSValue *) ;

static	int		WriteBufferModified ;

protected:

virtual DSValue *	FindAttribute(WORD attrIndex, WORD valueIndex)	= 0 ;
virtual NWPSTR *	AttributeNames()				= 0 ;
virtual WORD *		AttributeCount()				= 0 ;
virtual NWPSTR		ClassName()					= 0 ;

public:
			DSObject() { }

virtual	NWDSCCODE	ForAll(DSForAllFunc, void * = 0, void * = 0) ;

virtual NWDSCCODE	ReadObject (NWPSTR rdn, DSBuffer * buffer) ;

virtual NWDSCCODE	WriteObject(NWPSTR rdn, DSBuffer * buffer, DSObject * oldObject = 0) ;

virtual NWDSCCODE	CompareObject(DSObject * oldObject) ;

virtual	NWDSCCODE	Release()
				{ return ForAll(ReleaseAll) ; }
virtual int		operator==(DSObject & object)
				{ return CompareObject(& object) == 0 ; }
virtual int		operator!=(DSObject & object)
				{ return CompareObject(& object) ; }
#ifdef DSCPP_IOSTREAM
virtual	ostream &	OStream(ostream & s)
				{ ForAll(DisplayAll,& s) ; return s ; }

friend	ostream &	operator<<(ostream & s, DSObject & o)
				{ return o.OStream(s) ; }
#endif DSCPP_IOSTREAM
} ;

/*
** Class DSReadObject
**
**	Transfers the data from a NWDSRead, NWDSList or NWDSSearch to a
**	DSObject. For each attribute, SetAttrName searches the object's
**	attribute list (using the member function AttributeName()) for the
**	attribute's number. For each value, SetAttrValue calls the object's
**	member function FindAttribute() to get a pointer to the DSValue to
**	hold the data.
*/

class _DSCLASSDEC DSReadObject : public DSIteration
{
	DSObject *	Object ;
	WORD		AttrIndex ;
	WORD		ValueIndex ;
public:
			DSReadObject(DSObject * object)
				{ Object = object ; }
	NWDSCCODE	InitLoop()
				{ AttrIndex = 0 ; return 0 ; }
	NWDSCCODE	SetAttrName(NWPSTR attrName, NWSYNTAX_ID syntax) ;

	NWDSCCODE	SetAttrValue(NWSYNTAX_ID syntax, void * data) ;
} ;

#ifdef DSCPP_IOSTREAM
	ostream &	operator<<(ostream & s, DSObject & v) ;
#endif DSCPP_IOSTREAM

#endif dsOBJECT_H

