/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSFILE.H - October 1994
**
**	Declaration of the DSFile and DSFileStream classes.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# ifndef dsFILE_H
# define dsFILE_H

# include "dsdefs.h"
# include <io.h>

/*
** Class DSFile
**
**	Low level access to an NDS Stream attribute.
*/

class _DSCLASSDEC DSFile
{
protected:
	NWDSContextHandle	Context ;
	NWDSCCODE		Status ;
	NWDS_LOGIN_FILE		Handle ;
public:
			DSFile(NWDSContextHandle context)
				{ Context = context ; Handle = -1 ; Status = 0 ; }
			DSFile(DSFile &) ;
	virtual	      ~ DSFile() 			{ close() ; }
	void		operator=(DSFile &) ;
			operator NWDS_LOGIN_FILE()	{ return Handle ; }

	NWDSCCODE	status() 	{ return Status ; }
	NWDSCCODE	reset () 	{ return Status = 0 ; }
	NWDSCCODE	create(NWPSTR object, NWPSTR attr) ;
	NWDSCCODE	unlink(NWPSTR object, NWPSTR attr) ;
	NWDS_LOGIN_FILE	open  (NWPSTR object, NWPSTR attr, DWORD mode) ;
	int		close () ;

	long		lseek (long offset, int fromWhere)
				{ return ::lseek(Handle,offset,fromWhere) ; }
	int		read  (void * buffer, unsigned length)
				{ return ::read (Handle,buffer,length) ; }
	int		write (void * buffer, unsigned length)
				{ return ::write(Handle,buffer,length) ; }

} ;

# endif dsFILE_H
