/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSDEFS.H - October 1994
**
**	Definitions used by the NDS C++ Library
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# ifndef dsDEFS_H
# define dsDEFS_H

# ifdef DSCPP_WINDOWS
# include <windows.h>
# endif

# ifdef DSCPP_IOSTREAM
# include <iostream.h>
# endif

# include <nwnet.h>

# ifdef DSCPP_NWCALLS
# include <nwcalls.h>
# endif

/*
** The DSCPP_EXPORT and DSCPP_IMPORT macros are for generating and using a
** Windows DLL. To convert these source files into a DLL use the LibMain()
** in NWNDSCPP.CPP and compile all source files with DSCPP_EXPORT set true.
** To use the library the macro DSCPP_IMPORT must be set true. When using
** static linking (either in DOS or Windows) then have both macros false.
**
** These macro have been designed for Borland C++ 4 compilers.
*/

# if defined DSCPP_EXPORT
#   define _DSCLASSDEC _export
#   define _DSFUNCDEC  _export
#   define _DSTEMPDEC  inline
# elif defined DSCPP_IMPORT
#   define _DSCLASSDEC _import
#   define _DSFUNCDEC  _export
#   define _DSTEMPDEC
# else
#   define _DSCLASSDEC far
#   define _DSFUNCDEC
#   define _DSTEMPDEC
# endif

/*
** The definition of NWDS_LOGIN_FILE is incorrect in the new CD-ROM. It is
** defined as a short int while the prototype for NWDSOpenStream in
** NWDSDSA.H expects an int.
*/

# ifndef DSCPP_OLDVERSION
# undef  NWDS_LOGIN_FILE
# define NWDS_LOGIN_FILE int
# endif

/*
** Several new functions and one new type were introduced with SDK 4.1.
** The following definitions are provided for compatibility with version 1.0e
** of the SDK.
*/

# ifdef DSCPP_OLDVERSION
typedef struct
{
	uint32		wholeSeconds ;
	uint16		replicaNum ;
	uint16		eventID ;
} TimeStamp_T ;

inline NWDSCCODE NWDSInspectEntry(...)			{ return 0xffff ; }
inline NWDSCCODE NWDSPartitionReceiveAllUpdates(...)	{ return 0xffff ; }
inline NWDSCCODE NWDSPartitionSendAllUpdates(...)	{ return 0xffff ; }
inline NWDSCCODE NWDSSyncPartition(...)			{ return 0xffff ; }
inline NWDSCCODE NWDSAbortPartitionOperation(...)	{ return 0xffff ; }
inline NWDSCCODE NWDSAddSecurityEquiv(...)		{ return 0xffff ; }
inline NWDSCCODE NWDSRemSecurityEquiv(...)		{ return 0xffff ; }
inline NWDSCCODE NWDSExtSyncList(...)			{ return 0xffff ; }
inline NWDSCCODE NWDSExtSyncRead(...)			{ return 0xffff ; }
inline NWDSCCODE NWDSExtSyncSearch(...)			{ return 0xffff ; }
inline NWDSCCODE NWDSReadReferences(...)		{ return 0xffff ; }
# endif

# endif dsDEFS_H
