/* ---------------------------------------------------------------------------
                    TEMPLATE EXAMPLE #1 OF THE USE OF DMM

Step to run:
 - Compile
 - Link
 - Data File Link

*/

	#include "dmm.h"
	#include <stdio.h>
	#include <stdlib.h>
	#include <conio.h>
	#include <time.h>

struct TBlockInfo BlockInfo;

/* -------------------------------------------------------------------------
				FILL A BLOCK
*/

unsigned char fill( int blockid, int blocksize ) {
  unsigned char huge *myptr;
  unsigned char k,l;
  long i;

  myptr= BLOCKLOAD( blockid );
  l=0;

  for (i=0; i<blocksize*64; i++) {
    k= random( 256 ); l+= k;
    *myptr= k; myptr+=16;
  }
  BST[ blockid ]=0;
  return -l;
}

/* --------------------------------------------------------------------------
                        GET CHECKSUM OF A BLOCK
*/

unsigned char getchksum(int blockid, int blocksize) {
  unsigned char huge *myptr;
  unsigned char l;
  long i;

  myptr= BLOCKLOAD( blockid );
  l=0;

  for (i=0; i<blocksize*64; i++) {
    l+= *myptr;
    myptr+=16;
  }
  BST[ blockid ]=0;
  return -l;
}

/* -------------------------------------------------------------------------
				 ERROR TRAP
*/

void far DMM_ErrorTrap(char ErrCode) {
  char *ErrTraLst[]= { "",
                       "XMS fails",
                       "Too many locked blocks",
                       "Internal error",
                       "No block is available",
                       "You try to play with an uninitialized block" };

  printf("DMM error; %s", ErrTraLst[ ErrCode ]);
  DISCARD_DMM();
  exit(1);
}


/* -------------------------------------------------------------------------
				       MAIN

*/

int main() {
  char *InstErrLst[]= { "",
		       "Already installed",
		       "Not enough conventionnal memory",
		       "Not enough XMS memory",
		       "Not enough disk space",
		       "Invalid data file",
		       "XMS memory manager not present" };
  int
    i,
    total= 6,
    blocksize= 200,
    curblock,
    curchksum;
  char RC;

  randomize();
  printf("--------------------- This is an example of using DMM -----------------\n"
         " Allocates memory and fills it of random chars...\n\n");

  RC= INSTALL_DMM( "ex1.dat", blocksize, 1024, &DMM_ErrorTrap );
  if ( RC !=0 ) {
    printf( "DMM installation error: %s\n", InstErrLst[ RC ] );
    exit(1);
  }

  for (i=0; i<total; i++) {
    curblock= BLOCKCREATE( blocksize*64, 0 );
    curchksum= fill( curblock, blocksize );
    printf( "%dk allocated in block ID %d CHKSUM= %u\n",
	     blocksize, curblock, curchksum);
  }
    printf( "%dk total allocated\n", i*blocksize );

  do {
    printf("Load block ID %d  CHKSUM= %u\n", curblock,
                                            getchksum( curblock, blocksize ) );
    i--;
    curblock++;
  } while (i>0);

  DISCARD_DMM();
  return 0;
}
