#include <stdio.h>
#include <stdlib.h>
#include <setjmp.h>

#define far

#include "ed.h"
#include "paging.h"
#include "unassmbl.h"
#include "debug.h"

void movedata(int srcseg, int srcofs, int destseg, int destofs, int length);

ExternalDebuggerInfo edi;
TSS a_tss;
AREAS areas[MAX_AREA];

static int my_ds;
static int app_ds;
static int edi_seg;
static int edi_ofs;

void edi_init()
{
  int i;
  asm("movw $0xfe01,%ax");
  asm("int $0x21");
  asm("movl %edx,_edi_seg");
  asm("movl %eax,_edi_ofs");
  asm("xor  %eax,%eax");
  asm("movw %ds,%ax");
  asm("movl %eax,_my_ds");
  movedata(edi_seg, edi_ofs, my_ds, (int)(&edi), sizeof(edi));
  movedata(edi.a_tss_seg, edi.a_tss_ofs, my_ds, (int)(&a_tss), sizeof(TSS));
  app_ds = a_tss.tss_ds;
  movedata(edi.areas_seg, edi.areas_ofs, my_ds, (int)areas, sizeof(areas));
  for (i=0; i<MAX_AREA; i++)
  {
    areas[i].first_addr -= edi.app_base;
    areas[i].last_addr -= edi.app_base;
  }
}

void run_child(void)
{
  int i;
  movedata(my_ds, (int)(&edi), edi_seg, edi_ofs, sizeof(edi));
  movedata(my_ds, (int)(&a_tss), edi.a_tss_seg, edi.a_tss_ofs, sizeof(TSS));
  asm("movw $0xfe00,%ax");
  asm("int $0x21");
  movedata(edi_seg, edi_ofs, my_ds, (int)(&edi), sizeof(edi));
  movedata(edi.a_tss_seg, edi.a_tss_ofs, my_ds, (int)(&a_tss), sizeof(TSS));

  movedata(edi.areas_seg, edi.areas_ofs, my_ds, (int)areas, sizeof(areas));
  for (i=0; i<MAX_AREA; i++)
  {
    areas[i].first_addr -= edi.app_base;
    areas[i].last_addr -= edi.app_base;
  }
}

static int invalid_addr(word32 a, unsigned len)
{
  int i;
  if ((int)invalid_addr > 0)
    return 0;
  for (i=0; i<MAX_AREA; i++)
    if (a>=areas[i].first_addr && (a+len-1) <= areas[i].last_addr)
      return 0;
  printf("Invalid access to child, address %#x length %#x\n", a, len);
  if (can_longjmp)
    longjmp(debugger_jmpbuf, 1);
  return 1;
}

int read_child(word32 child_addr, void *buf, unsigned len)
{
  if (invalid_addr(child_addr, len))
    return 1;
  movedata(app_ds, child_addr, my_ds, (int)buf, len);
  return 0;
}

int write_child(word32 child_addr, void *buf, unsigned len)
{
  if (invalid_addr(child_addr, len))
    return 1;
  movedata(my_ds, (int)buf, app_ds, child_addr, len);
  return 0;
}

void ansi(int fg)
{
  if (!edi.ansi_mode)
    return;
  printf("\033[%d;%dm", (fg & A_bold) ? 1 : 0, 30+(fg&7));
}

int main()
{
  char *fn;
  int i, v;

  edi_init();

  fn = (char *)malloc(edi.filename_len + 1);
  movedata(edi.filename_seg, edi.filename_ofs, my_ds, (int)(fn), edi.filename_len+1);
/*
  printf("text: %#08x - %#08x\n", areas[A_text].first_addr, areas[A_text].last_addr);
  printf("data: %#08x - %#08x\n", areas[A_data].first_addr, areas[A_data].last_addr);
  printf("bss:  %#08x - %#08x\n", areas[A_bss].first_addr, areas[A_bss].last_addr);
  */
  syms_init(fn);

  debugger();

  return 0;
}

void *sbrk(int l)
{
  extern int end;
  static int sold = (int)&end;
  sold += l;
  return (void *)(sold-l);
}
