/* This is file UTILS.C */
/*
** Copyright (C) 1993 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

/* History:130,1 */

#include <dos.h>

#include "gotypes.h"
#include "tss.h"
#include "gdt.h"
#include "utils.h"
#include "dpmi.h"
#include "mswitch.h"
#include "exphdlr.h"

extern void _do_memset32();
extern void _do_memmov32();
extern void _do_memscan32();

extern int was_exception;

TSS *utils_tss = &o_tss;

void go_til_stop(void)
{
  while (1)
  {
    if (use_DPMI)
    {
      if (!DPMIexecute())
        return;
    }
    else
    {
      go32();
      if (!was_exception)
        return;
    }
    if (exception_handler())
      return;
  }
}

void zero32(word32 vaddr)
{
  TSS *old_ptr;
  old_ptr = tss_ptr;
  tss_ptr = utils_tss;
  utils_tss->tss_eip = (word16)_do_memset32;
  utils_tss->tss_eax = 0;
  utils_tss->tss_ecx = 4096;
  utils_tss->tss_es = g_core*8;
  utils_tss->tss_edi = vaddr;
  go_til_stop();
  tss_ptr = old_ptr;
}

void memput(word32 vaddr, void far *ptr, word16 len)
{
  if (use_DPMI)
    Pmemput(tss_ptr->tss_ds, vaddr, (void *)ptr, len);
  else {
  TSS *old_ptr;
/*  if (tss_ptr == &ed_tss)
    vaddr += 0x90000000L; */
  old_ptr = tss_ptr;
  tss_ptr = utils_tss;
  utils_tss->tss_eip = (word16)_do_memmov32;
  utils_tss->tss_ecx = len;
  utils_tss->tss_es = g_core*8;
  utils_tss->tss_edi = vaddr;
  utils_tss->tss_ds = g_core*8;
  utils_tss->tss_esi = (word32)FP_SEG(ptr)*16 + (word32)FP_OFF(ptr);
  go_til_stop();
  tss_ptr = old_ptr;
  }
}

void memget(word32 vaddr, void far *ptr, word16 len)
{
  if (use_DPMI)
    Pmemget(tss_ptr->tss_ds, vaddr, (void *)ptr, len);
  else {
  TSS *old_ptr;
/*  if (tss_ptr == &ed_tss)
    vaddr += 0x90000000L; */
  old_ptr = tss_ptr;
  tss_ptr = utils_tss;
  utils_tss->tss_eip = (word16)_do_memmov32;
  utils_tss->tss_ecx = len;
  utils_tss->tss_es = g_core*8;
  utils_tss->tss_edi = (word32)FP_SEG(ptr)*16 + (word32)FP_OFF(ptr);
  utils_tss->tss_ds = g_core*8;
  utils_tss->tss_esi = vaddr;
  go_til_stop();
  tss_ptr = old_ptr;
  }
}

void memscan32(word32 vaddr, void far *ptr, char term)
{
  TSS *old_ptr;
  old_ptr = tss_ptr;
  tss_ptr = utils_tss;
  utils_tss->tss_ebx = term;
  utils_tss->tss_eip = (word16)_do_memscan32;
  utils_tss->tss_es = g_core*8;
  utils_tss->tss_edi = (word32)FP_SEG(ptr)*16 + (word32)FP_OFF(ptr);
  utils_tss->tss_ds = g_core*8;
  utils_tss->tss_esi = vaddr;
  go_til_stop();
  tss_ptr = old_ptr;
}

word32 peek32(word32 vaddr)
{
  word32 rv;
  memget(vaddr, &rv, 4);
  return rv;
}

word16 peek16(word32 vaddr)
{
  word16 rv=0;
  memget(vaddr, &rv, 2);
  return rv;
}

word8 peek8(word32 vaddr)
{
  word8 rv=0;
  memget(vaddr, &rv, 1);
  return rv;
}
/*
void poke32(word32 vaddr, word32 v)
{
  memput(vaddr, &v, 4);
}

void poke16(word32 vaddr, word16 v)
{
  memput(vaddr, &v, 2);
}

void poke8(word32 vaddr, word8 v)
{
  memput(vaddr, &v, 1);
} */
