#include <stdio.h>
#include "ed.h"
#include "syms.h"

#define SC(r,c) (*(char *)(sc + (r)*ScreenCols() + (c)))
#define SW(r,c) (*(sc + (r)*ScreenCols() + (c)))

TSS a_tss;
main(int argc, char **argv)
{
  int r, c;
  short *sc;
  char *n;
  char buf[90];
  int i, line;
  word32 v;
  word32 d;
  char *func, *file;

  if (argc < 2)
  {
    fprintf(stderr, "Usage: symify <program>\n");
    fprintf(stderr, "This program replaces the stack dumps from go32 with debug info\n");
    return 1;
  }
  syms_init(argv[1]);

  sc = (short *)malloc(ScreenRows() * ScreenCols() * 2);

  ScreenRetrieve(sc);

  for (r=0; r<ScreenRows(); r++)
  {
    if (SC(r,0) == ' ' && SC(r,1) == ' ' && SC(r,2) == '0' && SC(r,3) == 'x')
    {
      buf[8] = 0;
      for (i=0; i<8; i++)
        buf[i] = SC(r, i+4);
      sscanf(buf, "%x", &v);
      func = syms_val2name(v, &d);
      file = syms_val2line(v, &line, 0);
      buf[0] = 0;
      if (func)
      {
	strcpy(buf, func);
	if (d)
	  sprintf(buf+strlen(buf), "%+d", d);
      }
      if (file)
      {
        if (buf[0])
          strcat(buf, ", ");
        sprintf(buf+strlen(buf), "line %d of %s", line, file);
      }
      if (buf[0])
        for (i=0; buf[i]; i++)
          SW(r, 15+i) = 0x0f00 + buf[i];
    }
  }

  ScreenUpdate(sc);
}
