/* This file may have been modified by DJ Delorie (Jan 1991).  If so,
** these modifications are Coyright (C) 1991 DJ Delorie, 24 Kirsten Ave,
** Rochester NH, 03867-2954, USA.
*/

#ifndef unistd_h
#define unistd_h 1

#include <sys/fcntl.h>

/* A safe-looking set of things from various system versions */

#ifndef	FNM_PATHNAME
#define FNM_PATHNAME 1
#endif

#ifndef	FNM_QUOTE
#define FNM_QUOTE 2
#endif

#ifndef SEEK_SET
#define SEEK_SET 0
#endif

#ifndef SEEK_CUR
#define SEEK_CUR 1
#endif

#ifndef SEEK_END
#define SEEK_END 2
#endif

#ifndef GF_PATH
#define GF_PATH "/etc/group"
#endif

#ifndef PF_PATH
#define PF_PATH "/etc/passwd"
#endif

#ifndef IN_PATH
#define IN_PATH "/usr/include"
#endif

#ifndef R_OK
#define R_OK 4
#endif

#ifndef W_OK
#define W_OK 2
#endif

#ifndef X_OK
#define X_OK 1
#endif

#ifndef F_OK
#define F_OK 0
#endif

#ifndef NULL
#define NULL 0
#endif

#ifndef F_ULOCK
#define F_ULOCK 0
#endif

#ifndef F_LOCK
#define F_LOCK 1
#endif

#ifndef F_TLOCK
#define F_TLOCK 2
#endif

#ifndef F_TEST
#define F_TEST 3
#endif

#ifdef	__cplusplus
extern "C" {
#endif
extern long	sysconf(int);
extern long	pathconf(const char *, int);
extern long	fpathconf(int, int);
#ifdef	__cplusplus
}
#endif

/* Miscellaneous constants */
#define _POSIX_VERSION		199009L
#define	_POSIX2_VERSION		198909L
#define	_POSIX2_C_BIND		1	/* Not sure what this means */
#define	_POSIX2_C_DEV		-1
#define	_POSIX2_FORT_DEV	-1
#define	_POSIX2_SW_DEV		-1
#define	_XOPEN_VERSION		3

/* sysconf() values from POSIX.1 */
#define	_SC_ARG_MAX		0	/* Max length of arg to exec() */
#define	_SC_CHILD_MAX		1	/* Max processes per userid */
#define	_SC_CLK_TCK		2	/* Number of clock ticks per second */
#define	_SC_NGROUPS_MAX		3	/* Max group IDs per process */
#define	_SC_OPEN_MAX		4	/* Max open files per process */
#define	_SC_JOB_CONTROL		5	/* POSIX job control supported */
#define	_SC_SAVED_IDS		6	/* POSIX saved IDs supported */
#define	_SC_VERSION		7	/* Date of POSIX.1 */
/* sysconf() values from POSIX.1-1990 */
#define	_SC_STREAM_MAX		100	/* Max open stdio FILEs */
#define	_SC_TZNAME_MAX		101	/* Max length of timezone name */
/* sysconf() values from POSIX.2 */
#define	_SC_BC_BASE_MAX		200	/* Largest ibase & obase for bc */
#define	_SC_BC_DIM_MAX		201	/* Max array elements for bc */
#define	_SC_BC_SCALE_MAX	202	/* Max scale value for bc */
#define	_SC_COLL_ELEM_MAX	203	/* Max bytes in collation element */
#define	_SC_EXPR_NEST_MAX	204	/* Max nesting of (...) for expr */
#define	_SC_LINE_MAX		205	/* Max length in bytes of input line */
#define	_SC_PASTE_FILES_MAX	206	/* Max file operands for paste */
#define	_SC_RE_DUP_MAX		207	/* Max regular expressions permitted */
#define	_SC_SED_PATTERN_MAX	208	/* Max size of bytes of sed pattern */
#define	_SC_SENDTO_MAX		209	/* Max bytes of message for sendto */
#define	_SC_SORT_LINE_MAX	210	/* Max bytes of input line for sort */
#define	_SC_2_VERSION		211	/* Current version of POSIX.2 */
#define	_SC_2_C_BIND		212	/* C Language Bindings Option */
#define	_SC_2_C_DEV		213	/* C Development Utilities Option */
#define	_SC_2_FORT_DEV		214	/* FORTRAN Dev. Utilities Option */
#define	_SC_2_SW_DEV		215	/* Software Dev. Utilities Option */
/* sysconf() values from X/Open */
#define	_SC_XOPEN_VERSION	8	/* Issue of XPG */
#define	_SC_PASS_MAX		9	/* Max bytes in password */
#define	_SC_CLOCKS_PER_SEC	2000	/* Units/sec of clock() */
/* sysconf() values from OSF */
#define	_SC_AES_OS_VERSION	3000	/* Version of OSF/AES OS */
#define	_SC_PAGE_SIZE		3001	/* Software page size */
#define	_SC_ATEXIT_MAX		3002	/* Max atexit() funcs */

/* pathconf() values from POSIX.1 */
#define	_PC_LINK_MAX		0	/* Max links to a single file */
#define	_PC_MAX_CANON		1	/* Max bytes in TTY canonical input */
#define	_PC_MAX_INPUT		2	/* Max bytes in TTY input queue */
#define	_PC_NAME_MAX		3	/* Max bytes in a filename */
#define	_PC_PATH_MAX		4	/* Max bytes in a pathname */
#define	_PC_PIPE_BUF		5	/* Max bytes for atomic pipe writes */ 
#define	_PC_CHOWN_RESTRICTED	6	/* Only privileged user can chown() */
#define	_PC_NO_TRUNC		7	/* Error when NAME_MAX exceeded */
#define	_PC_VDISABLE		8	/* Char disables TTY editing chars */

#endif


