#ifndef UNIX
#  ifdef unix
#    define UNIX
#  endif
#  ifdef M_XENIX
#    define UNIX
#  endif
#endif
#ifndef UNIX
#  ifdef __TURBOC__
#    include <io.h>
#  else
#    include <sys/types.h>
#  endif
#  include <sys/stat.h>
#  include <fcntl.h>
#endif
#include "modern.h"
#ifdef MODERN
#  ifndef __GNUC__
#    include <stdlib.h>
#  endif
#endif

/* Minix needs it after all the other includes (?) */
#include <stdio.h>

#include "diszip.h"

#define ERROR (-1)

static FILE *inp;
static int  out;

int getchr(void)
{
   register c = getc(inp);
   if (ferror(inp)) {
      perror("Read error"); exit(-1);
   }
   return c;
}

main(argc, argv)
int argc; char *argv[];
{
   char buf[1024];
   register i;

   if (argc != 3) {
      (void)fprintf(stderr,  "Usage: diszip <input> <output>\n");
      return -1;
   }
   if ((inp = fopen(argv[1], "rb")) == NULL) {
      perror(argv[1]); return -1;
   }
#ifdef UNIX
   out = creat(argv[2], 0666);
#else
   out = open(argv[2], O_CREAT+O_TRUNC+O_WRONLY+O_BINARY, S_IREAD+S_IWRITE);
#endif
   if (out < 0) {
      perror(argv[2]); return -1;
   }
   if (unzopen(getchr, ZIP_ANY)) {
      (void)fprintf(stderr, "Unzip error: %s\n", ziperrlist[ziperror]);
      return -1;
   }

   do {
      if ((i = unzread(buf, sizeof(buf))) == ERROR) {
         (void)fprintf(stderr, "Unzip error: %s\n", ziperrlist[ziperror]);
         return -1;
      }
      if (i > 0 && write(out, buf, i) != i) {
         perror("Write error"); return -1;
      }
   } while (i == sizeof(buf));
   if ((i = unzclose()) != 0) {
      (void)fprintf(stderr, "Unzip %s: %s\n",
         i==ERROR ? "error" : "warning", ziperrlist[ziperror]);
   }
   return i;
}
