//
// $Header$
// $Log$
//
// Copyright 1991
//
// Objective Systems, Inc.
//  Richard A. Doust        3/13/91
//  Phone:                  (201) 335-0691
//

#include <ctype.h>
#include <string.h>
#include <ui_win.hpp>
#include <pxengine.h>
#include <pdxpp.h>
#include "prndlg.hpp"

USHORT empty(const char *s, int len);

/**********************************************************************/
// Constructor
//
// This dialog box allows data entry/edit of the Printer Table.  These
// are the printers to whom materials may have been sent.
//
/**********************************************************************/
PrinterDialog::PrinterDialog(void) 
: UIW_WINDOW(2, 5, 63, 12, WOF_NO_FLAGS, NO_HELP_CONTEXT), 
PrinterTable("printers"),
PrintRec(PrinterTable),
PrnNumFld(PrinterTable, "PrinterNumber"),
PrnNameFld(PrinterTable, "PrinterName"),
PrnTeleFld(PrinterTable, "Telephone"),
PrnFaxFld(PrinterTable, "FaxNumber")
{
    *this
        + new UIW_BORDER
        + new UIW_MAXIMIZE_BUTTON
        + new UIW_MINIMIZE_BUTTON
        + new UIW_SYSTEM_BUTTON
        + new UIW_TITLE(" Printer List Maintenance", WOF_NO_FLAGS)
        + new UIW_PROMPT(2, 1, "Printer Number.....", WOF_NO_FLAGS)
        + (PrnNumEdit = new UIW_STRING(21, 1, 8, NULL, 7, STF_NO_FLAGS, 
                WOF_BORDER | WOF_NO_UNANSWERED | WOF_UNANSWERED, 
                PrinterDialog::Validate))
        + new UIW_PROMPT(2, 2, "Printer Name.......", WOF_NO_FLAGS)
        + (PrnNamEdit = new UIW_STRING(21, 2, 38, NULL, 35, STF_NO_FLAGS,
                WOF_BORDER))
        + new UIW_PROMPT(2, 3, "Telephone..........", WOF_NO_FLAGS)
        + (PrnTelEdit = new UIW_FORMATTED_STRING(21, 3, 16, "", 
                "LNNNLLNNNLXXXX", "(...) ...-....", WOF_BORDER))
        + new UIW_PROMPT(2, 4, "Fax Number.........", WOF_NO_FLAGS)
        + (PrnFaxEdit = new UIW_FORMATTED_STRING(21, 4, 16, "",
                "LNNNLLNNNLXXXX", "(...) ...-....", WOF_BORDER))
        + new UIW_BUTTON(2, 6, 10, "OK", BTF_NO_FLAGS, 
                WOF_BORDER | WOF_JUSTIFY_CENTER, PrinterDialog::Process)
        + new UIW_BUTTON(17, 6, 10, "Esc=Exit", BTF_NO_FLAGS,
                WOF_BORDER | WOF_JUSTIFY_CENTER, PrinterDialog::Cancel)
        + new UIW_BUTTON(32, 6, 10, "NEXT", BTF_NO_FLAGS,
                WOF_BORDER | WOF_JUSTIFY_CENTER, PrinterDialog::Next)
        + new UIW_BUTTON(47, 6, 10, "PREV", BTF_NO_FLAGS,
                WOF_BORDER | WOF_JUSTIFY_CENTER, PrinterDialog::Prev) 
        + new UIW_BUTTON(2, 8, 10, "DELETE", BTF_NO_FLAGS,
                WOF_BORDER | WOF_JUSTIFY_CENTER, PrinterDialog::Delete)
        + new UIW_BUTTON(17, 8, 10, "CLEAR", BTF_NO_FLAGS,
                WOF_BORDER | WOF_JUSTIFY_CENTER, PrinterDialog::Clear)
        + new UIW_BUTTON(32, 8, 10, "FIRST", BTF_NO_FLAGS,
                WOF_BORDER | WOF_JUSTIFY_CENTER, PrinterDialog::First)
        + new UIW_BUTTON(47, 8, 10, "LAST", BTF_NO_FLAGS,
                WOF_BORDER | WOF_JUSTIFY_CENTER, PrinterDialog::Last)
    ;

    if (PrinterTable.Result() != PXSUCCESS)
        error = TRUE;
    else
        error = FALSE;
}

/**********************************************************************/
//
// This is the method that processes events for the dialog.  The events
// handled are:
//              DISPLAY_DATA        Refreshes the screen with the data
//                                  currently stored in the member
//                                  character arrays
//              UPDATE_DATA         Gets the data out of the edit
//                                  controls, into member character
//                                  arrays, and then into the field
//                                  objects
//              CLEAR_DIALOG        Resets the member character arrays
//                                  to contain all spaces, then updates
//                                  the edit controls with those empty
//                                  strings
//              READ_RECORD         Reads the record currently pointed
//                                  to by the PXRECORD member
//              UPDATE_RECORD       Updates the record currently pointed
//                                  to by the PXRECORD member using
//                                  the values in the PXFIELD members
//              APPEND_RECORD       Appends a record to the PXTABLE
//                                  member, using the values in the
//                                  PXFIELD members
//              NEXT_RECORD         Moves the record pointer to the next
//                                  record sequentially, reads that
//                                  record, and updates the screen with
//                                  its contents
//              FIRST_RECORD        Moves the record pointer to the first
//                                  record, reads that record, and 
//                                  updates the screen with its contents
//              PREV_RECORD         Moves the record pointer to the 
//                                  preceding record sequentially, reads 
//                                  that record, and updates the screen 
//                                  with its contents
//              LAST_RECORD         Moves the record pointer to the last
//                                  record, reads that record, and
//                                  updates the screen with its contents
//
/**********************************************************************/
int  PrinterDialog::Event(const UI_EVENT &event)
{
UI_EVENT tevent;

    switch (event.type)
    {
        case DISPLAY_DATA:
            PrnNumEdit->DataSet(PrnNum);
            PrnNamEdit->DataSet(PrnName);
            PrnTelEdit->DataSet(PrnTele);
            PrnFaxEdit->DataSet(PrnFax);
            break;

        case UPDATE_DATA:
            const char *pData = PrnNumEdit->DataGet();
            strcpy(PrnNum, (char *)pData);
            pData = PrnNamEdit->DataGet();
            strcpy(PrnName, (char *)pData);
            pData = PrnTelEdit->DataGet();
            strcpy(PrnTele, (char *)pData);
            pData = PrnFaxEdit->DataGet();
            strcpy(PrnFax, (char *)pData);
            PrintRec.Put(PrnNumFld.FldHandle(), PrnNum);
            PrintRec.Put(PrnNameFld.FldHandle(), PrnName);
            PrintRec.Put(PrnTeleFld.FldHandle(), PrnTele);
            PrintRec.Put(PrnFaxFld.FldHandle(), PrnFax);
            break;

        case NEXT_RECORD:
            PrinterTable.Next();
            if (PrinterTable.Result() == PXERR_ENDOFTABLE)
            {
                _errorSystem->ReportError(windowManager, -1, 
                        "Already at end of Table.");
            }
            else
            {
                tevent.type = READ_RECORD;
                Event(tevent);
            }
            break;

        case PREV_RECORD:
            PrinterTable.Prev();
            if (PrinterTable.Result() == PXERR_STARTOFTABLE)
            {
                _errorSystem->ReportError(windowManager, -1, 
                        "Already at start of Table.");
            }
            else
            {
                tevent.type = READ_RECORD;
                Event(tevent);
            }
            break;

        case FIRST_RECORD:
            PrinterTable.First();
            if (PrinterTable.Result() != PXSUCCESS)
            {
                _errorSystem->ReportError(windowManager, -1, 
                        "Table is empty.");
            }
            else
            {
                tevent.type = READ_RECORD;
                Event(tevent);
            }
            break;

        case LAST_RECORD:
            PrinterTable.Last();
            if (PrinterTable.Result() != PXSUCCESS)
            {
                _errorSystem->ReportError(windowManager, -1, 
                        "Table is empty: %d.", PrinterTable.Result());
            }
            else
            {
                tevent.type = READ_RECORD;
                Event(event);
            }
            break;

        case CLEAR_DIALOG:
            PrnNum[0] = PrnName[0] = PrnTele[0] = PrnFax[0] = '\0';
            PrnNumEdit->DataSet(PrnNum);
            PrnNamEdit->DataSet(PrnName);
            PrnTelEdit->DataSet(PrnTele);
            PrnFaxEdit->DataSet(PrnFax);
            break;

        case READ_RECORD:
            PrintRec.RecGet();
            PrintRec.Get(PrnNumFld.FldHandle(), sizeof(PrnNum), PrnNum);
            PrintRec.Get(PrnNameFld.FldHandle(), sizeof(PrnName), PrnName);
            PrintRec.Get(PrnTeleFld.FldHandle(), sizeof(PrnTele), PrnTele);
            PrintRec.Get(PrnFaxFld.FldHandle(), sizeof(PrnFax), PrnFax);
            tevent.type = DISPLAY_DATA;
            Event(tevent);
            break;

        case UPDATE_RECORD:            
            PrintRec.Update();
            tevent.type = CLEAR_DIALOG;
            Event(tevent);
            break;

        case APPEND_RECORD:
            PrintRec.Append();
            tevent.type = CLEAR_DIALOG;
            Event(tevent);
            break;

        case DELETE_RECORD:
            PrintRec.Delete();
            tevent.type = CLEAR_DIALOG;
            Event(tevent);
            break;

        default:
            UIW_WINDOW::Event(event);
            break;

    }

    if (error)
    {
        _errorSystem->ReportError(windowManager, -1, "Printer Table error.");
        error = FALSE;
        UI_EVENT tevent;
        tevent.type = S_DELETE_LEVEL;
        eventManager->Put(tevent, Q_BEGIN);
    }

    return 0;
}

/**********************************************************************/
//
// Validation routine for the key field, the PrinterNumber field.
// When they exit this field, we read the table, looking for a match
// on the value entered into this field.  If we find one, we update
// the fields on the screen with that record's data.
//
/**********************************************************************/
int PrinterDialog::RetrieveData(void *StrFld, int ccode)
{
    switch (ccode)
    {
        case S_NON_CURRENT:
            PrintRec.Put(PrnNumFld, (char *)((UIW_STRING *)StrFld)->DataGet());
            if (PrintRec.SrchKey(1) == PXSUCCESS)
            {
                UI_EVENT event;
                event.type = READ_RECORD;
                ((UIW_STRING *)StrFld)->parent->Event(event);
            }
            break;
    }
    return 0;
}

/**********************************************************************/
//
// The static validation function which must call a non-static function
// in order to have access to the non-static data members.
//
/**********************************************************************/
int  PrinterDialog::Validate(void *StrFld, int ccode)
{
    return ((PrinterDialog *)((UIW_STRING *)StrFld)->parent)->RetrieveData(StrFld, ccode);
}

/**********************************************************************/
//
// The static OK button handler, calls the non-static version for access to
// non-static data members.
//
/**********************************************************************/
void PrinterDialog::Process(void *button, UI_EVENT &event)
{
    ((PrinterDialog *)((UIW_BUTTON *)button)->parent)->ProcessDialog(button, event);
}

/**********************************************************************/
//
// The user has hit the OK button.  We've got to get the string objects
// to update their data members in the class, then we can update the 
// database with the new information
//
/**********************************************************************/
void PrinterDialog::ProcessDialog(void *button, UI_EVENT &event)
{

    event.type = UPDATE_DATA;
    ((UIW_BUTTON *)button)->parent->Event(event);
    if (empty((const char *)PrnNum, sizeof(PrnNum)))
    {
        _errorSystem->ReportError(windowManager, -1, "Empty Key Field.");
        return;
    }
    if (strlen(PrnNum) < 6)
    {
        _errorSystem->ReportError(windowManager, -1, 
                "Key is required to be 6 characters.");
        return;
    }

    if (PrintRec.SrchKey(1) == PXSUCCESS)
        event.type = UPDATE_RECORD;
    else
        event.type = APPEND_RECORD;
    ((UIW_BUTTON *)button)->parent->Event(event);
}

/**********************************************************************/
//
// The cancel button has been hit.  Get rid of the dialog box.
//
/**********************************************************************/
void PrinterDialog::Cancel(void *button, UI_EVENT &event)
{
    event.type = S_DELETE_LEVEL;
    ((UIW_BUTTON *)button)->eventManager->Put(event, Q_BEGIN);
}

/**********************************************************************/
//
// The user hit the NEXT button.  Read the next record and display its
// data.
//
/**********************************************************************/
void PrinterDialog::Next(void *button, UI_EVENT &event)
{
    event.type = NEXT_RECORD;
    ((UIW_BUTTON *)button)->parent->Event(event);
}

/**********************************************************************/
//
// The user hit the PREV button.  Read the previous record and display
// its data.
//
/**********************************************************************/
void PrinterDialog::Prev(void *button, UI_EVENT &event)
{
    event.type = PREV_RECORD;
    ((UIW_BUTTON *)button)->parent->Event(event);
}

/**********************************************************************/
//
// The user hit the FIRST button.  Read the first record and display
// its data.
//
/**********************************************************************/
void PrinterDialog::First(void *button, UI_EVENT &event)
{
    event.type = FIRST_RECORD;
    ((UIW_BUTTON *)button)->parent->Event(event);
}
        
/**********************************************************************/
//
// The user hit the LAST button.  Read the last record and display its
// data.
//
/**********************************************************************/
void PrinterDialog::Last(void *button, UI_EVENT &event)
{
    event.type = LAST_RECORD;
    ((UIW_BUTTON *)button)->parent->Event(event);
}
    
/**********************************************************************/
//
// The user hit the CLEAR button.  Read the last record and display its
// data.
//
/**********************************************************************/
void PrinterDialog::Clear(void *button, UI_EVENT &event)
{
    event.type = CLEAR_DIALOG;
    ((UIW_BUTTON *)button)->parent->Event(event);
}

/**********************************************************************/
//
// The user hit the DELETE button.  Delete the current record.
//
/**********************************************************************/
void PrinterDialog::Delete(void *button, UI_EVENT &event)
{
    event.type = DELETE_RECORD;
    ((UIW_BUTTON *)button)->parent->Event(event);
}

/**********************************************************************/
//
// An internal function that tells the emptiness of a character array.
//
/**********************************************************************/
USHORT empty(const char *s, int len)
{
    for (int i = 0; i < len; ++i)
    {
        if (s[i])
        {
            if (!isspace(s[i]))
            {
                return FALSE;
            }
        }
        else
        {
            return TRUE;
        }
    }
    return TRUE;
}
