/*
    Test program for DateObject
*/

#include <stdio.h>
#include <iostream.h>
#include "dates.h"

void main(void)
{
    DateObject d1(1, 1, -4700, "d mmmm yyyy");
    DateObject d2(12, 31, 25000, "d mmmm yyyy");
	DateObject d3(5, 23, 1968, "d mmm yyy");
	DateObject d4;
	DateObject d5;
	long Diff;

	cout << "d1 has a Julian of " << d1.GetJulian() << "\n";
	cout << "d2 has a Julian of " << d2.GetJulian() << "\n";

    cout << "DateObjects can span from " << d1 << "\n";
    cout << "to " << d2 << ", or ";
    cout << (Diff = (d2 - d1)) << " days.\n\n";

    cout << "A good reference date is " << d3 << "\n";
    cout << "which should have a Julian date of 2440000.\n";
    cout << "If we call GetJulian() to make sure, we find\n";
	cout << "that is does";

	if (d3.GetJulian() != 2440000L)
        cout << " not";

    cout << ", in fact, equal 2440000.\n\n";

    cout << "Attempting to add " << Diff << " days to " << d3 << "\n";
    cout << "Yields a " << (d3 + Diff) << ".\n";

    cout << "However, adding " << Diff << " days to " << d1 << "\n";
    cout << "Yields " << (d1 + Diff) << ".\n\n";

    cout << "Today is " << d4 << ".\n";
    d4.ChangeFormat("dddd");
    cout << "The next five days are:\n";

    for (++d4; d4 <= d5 + 5; d4++)
        cout << d4 << "\n";

	cout << "\n";

	cout << d4.GetShortMonth() << "\n";
	cout << d4.GetLongMonth() << "\n";
}
