/*
	dates.h -- header file for dates.cpp, date object

    The original code for this object is from the June 1990 issue of
    The C Users Journal and was written by David Clark.

    Several improvements and modifications were added by Bill
    Pemberton.  The current code is written for Turbo C++.
*/  

#define     MINMONTH    1
#define     MAXMONTH    12
#define     MINDAY      1
#define     MAXDAY      31
#define     MINWEEKDAY  0
#define     MAXWEEKDAY  6
#define     BADDATE     -1L
#define     MINYEAR     -4700L
#define     MAXYEAR     25000L
#define     MINDATE     4749L       /* Jan 1, 4700 BC */
#define     MAXDATE     10852487L   /* Dec 31, 25000 */
#define     MAXDATESTRLEN   256

class DateObject
{
    long Julian;
    char *DateFormatPtr;
    unsigned char Day;
    unsigned char Month;
    int Year;   /* - years are BC */
    unsigned char DayOfWeek;

    public:

    DateObject(void);
    DateObject(DateObject &OtherDate);
    DateObject(unsigned char InitMonth, unsigned char InitDay, int InitYear);
    DateObject(unsigned char InitMonth, unsigned char InitDay, int InitYear,
                const char *FormatStr);

    DateObject operator = (DateObject &d);
    DateObject operator - (long x);
    DateObject operator ++ (void);
    DateObject operator -- (void);
    DateObject operator += (long x);
    DateObject operator -= (long x);
    int operator == (DateObject &d) {return(Julian == d.Julian);}
    int operator != (DateObject &d) {return(Julian != d.Julian);}
    int operator > (DateObject &d) {return(Julian > d.Julian);}
    int operator < (DateObject &d) {return(Julian < d.Julian);}
    int operator >= (DateObject &d) {return(Julian >= d.Julian);}
    int operator <= (DateObject &d) {return(Julian <= d.Julian);}

    int ValidDate(void) { return(Julian != BADDATE);}
    unsigned char GetDay(void) {return(Day);}
    unsigned char GetMonth(void) {return(Month);}
    int GetYear(void) {return(Year);}
    unsigned char GetDayOfWeek(void) {return(DayOfWeek);}
    long GetJulian(void) {return(Julian);}

    const char *GetFormat(void);
    int ChangeDate(unsigned char NDay, unsigned char NMonth, int NYear);
    void ChangeFormat(const char *s);

    char *GetShortMonth(void);
    char *GetLongMonth(void);
    char *GetLongDayOfWeek(void);
    char *GetShortDayOfWeek(void);
	char *DateToString(void);

    ~DateObject(void);

    friend DateObject operator + (DateObject &d, long x);
	friend DateObject operator + (long x, DateObject &d);
	friend long operator - (DateObject &d1, DateObject &d2)
		{ return(d1.Julian - d2.Julian); }
	
};

int ChangeDefaultDateFormat(const char *);

ostream& operator << (ostream& s, DateObject &d);
