#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <database.hpp>

main(int argc, char *argv[])
{
 char *wsp,ws[128];	// Useful work space
 int inc=0;		// Flag results to be printed in #include form

 if (argc<2)
 {
  printf("Usage : dbrpt filename [-c]\n");
  printf("        -c option prints in #include form for header files\n");
  exit(1);
 }
 if (argc>2) if (!strcmpl(argv[2],"-c")) inc=1;

 strcpy(ws,argv[1]); strupr(ws);
 if (wsp=strchr(ws,'.')) *wsp=0; if (wsp=strchr(ws,'\\')) *wsp=0;

 // Open database

 database *db=new database(argv[1]);
 if (db->isvalid())
 {
  delete db;
  printf("\nError on opening database !"); exit(1);
 }

 // Dump database stats.

 if (inc) printf("// Database %s, include file\n\n// ",ws);
 else printf("\n");
 printf("Database : %s has %ld records of length %d with %d fields\n",
	ws,db->getnrec(),db->getreclen(),db->getnfield());

 // Dump field stats

 for(int i=1; i<=db->getnfield(); i++)
 {
  field *fld;

  fld=db->getfield(i);
  if (inc) printf("\n#define %-10s %3d   // ",fld->getname(),i);
  else printf("\nField %3d - %-10s ",i,fld->getname());
  printf("Type %c, Length %3d, Rdp %d",
	  fld->gettype(),fld->getlen(),fld->getrdp());
 }

 printf("\n\n");
 delete db;
 exit(0);
}
