/*>>>>>>>>>>>>>>>>>>>>>>>>>>    CURSOR CONTROL     <<<<<<<<<<<<<<<<<<<<<<<<<<*/
/*   These functions permit cursor control using the DOS services.  They     */
/*   are not guaranteed to work on any given setup.  The bottom line is:     */
/*   if they work for you GREAT!, otherwise . . . 			     */
/*****************************************************************************/
#include <dos.h>

int CURSOR = 7;

void cursor_off(void)
/***************************************************************************/
/* Routine turns off the cursor on the default screen.                     */
/***************************************************************************/
{
	union REGS regs;
	regs.x.ax = 0x0100;
	regs.x.cx = 0x2000;
	int86 (0x10, &regs, &regs);
}

void cursor_on(void)
/***************************************************************************/
/* Routine turns on the cursor on the default screen.                      */
/***************************************************************************/
{
	union REGS regs;
	regs.x.ax = 0x0100;
	regs.h.ch = CURSOR - 1;
	regs.h.cl = CURSOR;
	int86 (0x10, &regs, &regs);
}

void cursor_size(int lo, int hi)
/***************************************************************************/
/* Routine changes the cursor size on the default screen.                  */
/***************************************************************************/
{
	union REGS regs;
	regs.h.ah = 0x0001;
	regs.h.ch = lo;
	regs.h.cl = hi;
	int86 (0x10, &regs, &regs);
}

/***************************************************************************/
/* Routine to test the cursor functions.                                   */
/***************************************************************************/
#include <stdio.h>
void main(void)
{
	int i;
	printf("Changing cursor size:   ");
	for (i=0; i<11; i++)
	{
		cursor_size(0,i);
		delay(250);
	}
	cursor_size(6,7);
	printf("\nThe cursor should be off!\n");
	cursor_off();
	sleep(3);
	cursor_on();
	printf("The cursor should be on!\n");
}

