/*
    Turbo C Technical Support Notes:
        Combines 43.C and 25.C EGA or setting 43-line and 25-line modes.

    Created:
        11/5/87

    Revision History:
*/

#include <process.h>
#include <conio.h>
#include <dos.h>
#include <stdio.h>

#define OFF 0
#define ON  1
#define NOCHANGE 2

#define TRUE  1
#define FALSE 0

void normvideo(void);
int  in43linemode(void);
void ega43(int mode);
int  egainstalled(void);
void setcursor(unsigned char start, unsigned char end);
int  egacursoremu(int mode);
int  egacursorsize(void);
extern unsigned char _video[];
void main(int argc, char *argv[])
{
    int toggle = NOCHANGE, i;
    _video[3] = 42;
    _video[7] = 43;
    if (!egainstalled()) {
        fprintf(stderr, "EGA not installed.\n");
        exit(1);
    }

    if (argc >= 2)
        switch(argv[1][0]) {
            case '?': toggle = NOCHANGE;
                      printf("usage: EGA43 [1][0]\n"
                             "1 = 43-line mode; "
                             "0 = 25-line mode; "
                             "no argument = toggle mode\n"
                            );
                      printf("43-line mode: %s\n",
                              in43linemode() ? "ON": "OFF");
                      printf("Cursor size : %d\n", egacursorsize());
                      break;
            case '0': toggle = OFF;
                      break;
            case '1': toggle = ON;
                      break;
            default : toggle = NOCHANGE;
         }



    if (argc == 1)
        switch(in43linemode()) {
            case TRUE:  toggle = OFF;     /* if already on, turn off */
                        break;
            case FALSE: toggle = ON;      /* if already off, turn on */
                        break;
        }

    if (toggle != NOCHANGE) normvideo();

    if (toggle == ON)  ega43(ON);
    if (toggle == OFF) ega43(OFF);
    for (i=0;i<43;i++) cprintf("%d\r\n",i);
    getch();
}


void normvideo(void)
{
    union REGS regs;

    regs.h.ah = 0;
    regs.h.al = 3;
    int86(0x10, &regs, &regs);

}

void ega43(int mode)
{
    union REGS regs;

    if (mode == OFF)
        regs.h.al = 0x11;
    else
        regs.h.al = 0x12;

    regs.h.ah = 0x11;
    regs.h.bl = 0;

    int86(0x10, &regs, &regs);

    egacursoremu(mode);
}

int egainstalled(void)
{
    union REGS regs;

    regs.x.ax = 0x1200;
    regs.x.bx = 0x0010;
    regs.x.cx = 0xFFFF;

    int86(0x10, &regs, &regs);

    if (regs.x.cx == 0xFFFF)
        return(FALSE);
    else
        return(TRUE);
}

void setcursor(unsigned char start, unsigned char end)
{
    union REGS regs;

    regs.h.ah = 1;
    regs.h.ch = start;  /* starting scan line */
    regs.h.cl = end;    /* ending scan line   */

    int86(0x10, &regs, &regs);

}

int egacursoremu(int mode)
{
    unsigned char far *emulation = MK_FP(0x40,0x87);

    if (mode == OFF) {
        *emulation &= ~0x01;
        setcursor(6, 7);
    }
    else {
        *emulation |= 0x01;
        setcursor(5, 7);
    }

    return(mode);
}

int in43linemode(void)
{
    unsigned char far *egamode = MK_FP(0x40,0x84);

    return ( (*egamode == 42)? TRUE: FALSE);

}

int egacursorsize(void)
{
    unsigned char far *size = MK_FP(0x40, 0x85);

    return( (int) *size);
}
