/*
 *  This is an example of an interrupt handler which traps the keyboard
 *  interrupt and generates some output to the screen.  It shows the way
 *  to deal with reentrancy and stack issues.
 */

#include <dos.h>
#include <conio.h>

#ifdef __cplusplus      // Handle C++ vs. C prototyping of handler functions
#define CPPARGS ...
#else
#define CPPARGS
#endif

#define INTR 0x09
#define ATTR 0x7900

// You can't use printf or any function which calls interrupts 3-16 from
// an asynchronous interrupt (like 9).  Your machine will hang.

unsigned char color = 0;
struct text_info oldtextinfo;
unsigned int mystack[3000];        // This is  the stack which we will use.
unsigned int oldSS;                // We'll have to save SS
unsigned int oldSP;                // And SP
unsigned int x, y, _9FLAG = 0;     // _9FLAG will be set so that we do not
                                   //  reenter ourselves.  If we reenter,
                                   // we will not be able to restore the
                                   // old stack.

void interrupt (*oldhandler)(CPPARGS);  // CPPARGS is dependent on whether
void interrupt handler(CPPARGS)         // the C or C++ compiler is used.
{
    if (_9FLAG)                     // if were already in here
    {                               // exit.  If not, set our flag
        (*oldhandler)();
        return;
    }
    _9FLAG = 1;
    x = wherex();                   // get cursor position
    y = wherey();
    oldSP = _SP;                    // switch to our stack
    oldSS = _SS;
    _SS = FP_SEG(mystack);
    _SP = FP_OFF(&mystack[2998]);

    gotoxy(40,10);                  // Switch cursor position
    gettextinfo(&oldtextinfo);      // Get old text color...
    textattr(color++);              // Change to something strange.
    cputs("Hello");                 // put "Hello" on the screen.
    textattr(oldtextinfo.attribute);// Change back to old text color.

    (*oldhandler)();                   // Call the old handler.
    _SS = oldSS;                    // Restore old stack.
    _SP = oldSP;
    gotoxy(x, y);                   // Restore old cursor position.
    _9FLAG = 0;                     // We're leaving our handler: now
}                                   // it's ok to enter the function.

int main(void)
{
    clrscr();
    oldhandler = getvect(INTR);     // Get old handler vector.
    setvect(INTR, handler);         // Install our new handler vector.

    cprintf("Press 'Q' to quit...any other key for effect.\n");
    while(getch() != 'Q')
;//        putch('.');

    setvect(INTR, oldhandler);      // Restore the old handler vector.
    return 0;
}
