/*

	sbnode.hpp
	8-27-91
	Streamable Binder Nodes

	Copyright 1991
	John W. Small
	All rights reserved

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	John Small
	Voice: (703) 759-3838
	CIS: 73757,2233

*/

#ifndef SBNODE_HPP
#define SBNODE_HPP

#ifndef BINDER_HPP
#include <binder.hpp>
#endif


class SBNode;
typedef SBNode * SBN;
#define SBN0 ((SBN)0)

#define ID_SBNode  3
#define DID_Generic	0
#define DID_String	1

class SBNode : Streamable {
	unsigned sizeofData, Did;
	int dup;
	voiD D;
protected:
	void construct(voiD D, unsigned sizeofData,
		unsigned Did, int dup);
public:
	STREAMABLE(SBNode,ID_SBNode,
		Streamable);
	SBNode(voiD D = voiD0,
		unsigned sizeofData = 0,
		unsigned Did  = DID_Generic,
		int dup = 1)
		: Streamable(UNIQUE_STREAMABLE,
			CLASS_ID)
		{ construct(D,sizeofData,Did,dup); }
	SBNode(char * s, int dup = 1);
	operator voiD() { return D; }
	unsigned SizeofData()
		{ return sizeofData; }
	unsigned DID() { return Did; }
	~SBNode() { if (dup) delete D; }
};

#endif
