/*
	CSTRINGS.LBR VERSION 1.0
	Spark Software, Inc.

		If you find this software of use, it is requested that you send
		a donation ($10.00 suggested) to:

			Spark Software, Inc.
			24 Royal Crest Dr., #5
			Nashua, NH  03060

		Upon receiving your donation, your name will be added to the 
		List of Registered Users, and future updates can be obtained
		from the SPARKIE RBBS at (603) 888-8179.

		If you include an extra $10.00 with your donation, the newest
		version of CSTRINGS.LBR will be mailed to you.

		Call SPARKIE RBBS at the number above for other Spark Software
		products!!!
*/

/*
 *	strsplit (str, out1, out2, n)
 *	char *str, **out1, **out2;
 *	int n;
 *
 *	This function creates two new strings (out1, and out2) from the
 *	original string (str).	The first string is formed by the first
 *	n characters of str (with a null terminator added if needed).
 *	The second string is formed by the rest of the characters in
 *	str (including the null terminator).  Note that the strings are
 *	assumed to be large enough to hold the results of the copying.
 *	Note also that the extern declarations given for strncpy()/strcpy()
 *	are required on many compilers (including Lattice C large model)
 *      where int's are not the same size as char *'s.
 */

strsplit (str, out1, out2, n)
register char *str, *out1, *out2;
int n;
{
	extern char *strncpy (), *strcpy ();
	int len_str;

					/* First determine the length of
					   the original string */
	len_str = strlen (str);

					/* Copy the characters into the
					   first string */
	out1 = strncpy (out1, str, n);

					/* Make sure that the string is
					   null terminated */
        out1[n + 1] = '\0';

					/* Put characters into the string
					   (if there are any to put in */
	if (len_str > n)
		out2 = strcpy (out2, &str[n]);

					/* Otherwise just create a null
					   string */
	else
                *out2 = '\0';

					/* Always return 0, for compilers
					   that need a return value */
	return (0);

} /* strsplit */
